/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.session.stateless;

import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.factory.session.SessionSpecProxyFactory;
import org.jboss.ejb3.proxy.factory.session.stateless.StatelessSessionProxyFactoryBase;
import org.jboss.ejb3.proxy.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.handler.session.stateless.StatelessRemoteProxyInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessSessionRemoteProxyFactory
extends StatelessSessionProxyFactoryBase
implements SessionSpecProxyFactory {
    private static final Logger logger = Logger.getLogger(StatelessSessionRemoteProxyFactory.class);
    private static final String DEFAULT_STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS = "StatelessSessionClientInterceptors";
    private String url;
    private String interceptorStackName;

    public StatelessSessionRemoteProxyFactory(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor, String interceptorStackName) {
        super(name, containerName, containerGuid, metadata, classloader, advisor);
        this.setUrl(url);
        this.setInterceptorStackName(interceptorStackName);
    }

    @Override
    protected final Set<String> getBusinessInterfaceTypes() {
        return this.getMetadata().getBusinessRemotes();
    }

    @Override
    protected final String getHomeType() {
        return this.getMetadata().getHome();
    }

    @Override
    protected final String getEjb2xInterfaceType() {
        return this.getMetadata().getRemote();
    }

    @Override
    protected String getInterceptorStackName() {
        String stackName = DEFAULT_STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS;
        String overrideName = this.interceptorStackName;
        if (overrideName != null && overrideName.trim().length() > 0) {
            stackName = overrideName;
        }
        return stackName;
    }

    @Override
    protected SessionProxyInvocationHandler createBusinessInterfaceSpecificInvocationHandler(String businessInterfaceName) {
        String containerName = this.getContainerName();
        String containerGuid = this.getContainerGuid();
        String url = this.getUrl();
        Interceptor[] interceptors = this.getInterceptors();
        StatelessRemoteProxyInvocationHandler handler = new StatelessRemoteProxyInvocationHandler(containerName, containerGuid, interceptors, businessInterfaceName, url);
        return handler;
    }

    @Override
    protected SessionProxyInvocationHandler createBusinessDefaultInvocationHandler() {
        return this.createBusinessInterfaceSpecificInvocationHandler(null);
    }

    @Override
    protected SessionProxyInvocationHandler createEjb2xComponentInterfaceInvocationHandler() {
        return this.createBusinessDefaultInvocationHandler();
    }

    @Override
    protected SessionProxyInvocationHandler createHomeInvocationHandler() {
        return this.createBusinessDefaultInvocationHandler();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    protected void setInterceptorStackName(String interceptorStackName) {
        this.interceptorStackName = interceptorStackName;
    }
}

