/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.test.common;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.ejb3.common.metadata.MetadataUtil;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.BasicJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JBossSessionPolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.process.chain.ProcessorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataHelper {
    private static final Logger log = Logger.getLogger(MetaDataHelper.class);

    public static JBossSessionBeanMetaData createMockBeanMetaData() {
        JBossMetaData metaData = new JBossMetaData();
        JBossEnterpriseBeansMetaData enterpriseBeans = new JBossEnterpriseBeansMetaData();
        metaData.setEnterpriseBeans(enterpriseBeans);
        metaData.setAssemblyDescriptor(new JBossAssemblyDescriptorMetaData());
        JBossSessionBeanMetaData sessionBeanMetaData = new JBossSessionBeanMetaData();
        sessionBeanMetaData.setEnterpriseBeansMetaData(enterpriseBeans);
        return sessionBeanMetaData;
    }

    public static JBossSessionBeanMetaData getMetadataFromBeanImplClass(Class<?> beanImplClass) {
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        HashSet classes = new HashSet();
        classes.add(beanImplClass);
        JBoss50MetaData metadata = new JBoss50Creator((AnnotationFinder)finder).create(classes);
        String ejbName = beanImplClass.getSimpleName();
        JBossSessionBeanMetaData beanMetaDataDelegate = (JBossSessionBeanMetaData)metadata.getEnterpriseBean(ejbName);
        assert (beanMetaDataDelegate != null) : "Bean metadata for " + ejbName + " could not be found";
        JBossSessionPolicyDecorator beanMetaData = new JBossSessionPolicyDecorator(beanMetaDataDelegate, (DefaultJndiBindingPolicy)new BasicJndiBindingPolicy());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ProcessorChain chain = MetadataUtil.getPostMergeMetadataProcessorChain((ClassLoader)cl);
        chain.process((JBossMetaData)metadata);
        return beanMetaData;
    }

    @Deprecated
    protected static ResourceReferenceMetaData createResourceEnvRef(Resource annotation, Field element) {
        String injectionName;
        Set injectionTargets;
        ResourceReferenceMetaData ref = new ResourceReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = MetaDataHelper.getName(element);
        }
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        if (annotation.type() != Object.class) {
            ref.setType(annotation.type().getName());
        } else {
            ref.setType(MetaDataHelper.getType(element));
        }
        Descriptions descriptions = ProcessorUtils.getDescription((String)annotation.description());
        if (descriptions != null) {
            ref.setDescriptions(descriptions);
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets((String)(injectionName = MetaDataHelper.getInjectionName(element)), (AnnotatedElement)element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    @Deprecated
    protected static String getName(Field element) {
        String name = element.getName();
        return name;
    }

    @Deprecated
    protected static String getInjectionName(Field element) {
        return element.getName();
    }

    @Deprecated
    protected static String getType(Field element) {
        return element.getType().getName();
    }

    @Deprecated
    protected static String getDeclaringClass(Field element) {
        return element.getDeclaringClass().getName();
    }
}

