/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.test.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.ejb3.common.metadata.MetadataUtil;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.process.chain.ProcessorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataHelper {
    private static final Logger log = Logger.getLogger(MetaDataHelper.class);

    public static JBossSessionBeanMetaData createMockBeanMetaData() {
        JBossMetaData metaData = new JBossMetaData();
        JBossEnterpriseBeansMetaData enterpriseBeans = new JBossEnterpriseBeansMetaData();
        metaData.setEnterpriseBeans(enterpriseBeans);
        metaData.setAssemblyDescriptor(new JBossAssemblyDescriptorMetaData());
        JBossSessionBeanMetaData sessionBeanMetaData = new JBossSessionBeanMetaData();
        sessionBeanMetaData.setEnterpriseBeansMetaData(enterpriseBeans);
        return sessionBeanMetaData;
    }

    public static JBossMetaData getMetaDataFromBeanImplClasses(Collection<Class<?>> beanImplClasses) {
        return MetaDataHelper.getMetaDataFromBeanImplClasses(beanImplClasses.toArray(new Class[0]));
    }

    public static JBossMetaData getMetaDataFromBeanImplClasses(Class<?>[] beanImplClasses) {
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        HashSet classes = new HashSet();
        for (Class<?> beanImplClass : beanImplClasses) {
            boolean unique = classes.add(beanImplClass);
            if (unique) continue;
            log.warn((Object)("Specified class " + beanImplClass + " was not unique, skipping..."));
        }
        JBoss50MetaData metadata = new JBoss50Creator((AnnotationFinder)finder).create(classes);
        log.debug((Object)("Decorating EJB3 EJBs in " + metadata + " with JNDI Policy"));
        MetadataUtil.decorateEjbsWithJndiPolicy((JBossMetaData)metadata, (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        }));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ProcessorChain chain = MetadataUtil.getPostMergeMetadataProcessorChain((ClassLoader)cl);
        chain.process((JBossMetaData)metadata);
        return metadata;
    }

    public static JBossSessionBeanMetaData getMetadataFromBeanImplClass(Class<?> beanImplClass) {
        JBossMetaData metadata = MetaDataHelper.getMetaDataFromBeanImplClasses(new Class[]{beanImplClass});
        String ejbName = beanImplClass.getSimpleName();
        JBossSessionBeanMetaData beanMetaData = (JBossSessionBeanMetaData)metadata.getEnterpriseBean(ejbName);
        assert (beanMetaData != null) : "Bean metadata for " + ejbName + " could not be found";
        return beanMetaData;
    }
}

