/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.test.deployers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockDeploymentUnit
extends AbstractDeploymentUnit
implements DeploymentUnit {
    private String name;
    private DeploymentUnit parent;
    private List<DeploymentUnit> children;
    private Map<String, Object> attachments;

    public MockDeploymentUnit(String name) {
        this.name = name;
        this.children = new ArrayList<DeploymentUnit>();
        this.attachments = new HashMap<String, Object>();
    }

    public MockDeploymentUnit(String name, DeploymentUnit parent) {
        this(name);
        this.parent = parent;
    }

    public void addChild(DeploymentUnit child) {
        this.children.add(child);
    }

    public List<DeploymentUnit> getChildren() {
        return this.children;
    }

    public DeploymentUnit getParent() {
        return this.parent;
    }

    public Object addAttachment(String name, Object attachment) {
        return this.attachments.put(name, attachment);
    }

    public Object getAttachment(String name) {
        return this.attachments.get(name);
    }

    public Map<String, Object> getAttachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": " + this.name;
    }

    public ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

