/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.secondary.bean;

import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.tutorial.secondary.bean.Customer;
import org.jboss.tutorial.secondary.bean.CustomerDAO;

@Stateless
@Remote(value={CustomerDAO.class})
public class CustomerDAOBean
implements CustomerDAO {
    @PersistenceContext
    private EntityManager manager;

    public int create(String first, String last, String street, String city, String state, String zip) {
        Customer customer = new Customer(first, last, street, city, state, zip);
        this.manager.persist((Object)customer);
        return customer.getId();
    }

    public Customer find(int id) {
        return (Customer)this.manager.find(Customer.class, (Object)id);
    }

    public List findByLastName(String name) {
        return this.manager.createQuery("from Customer c where c.last = :name").setParameter("name", (Object)name).getResultList();
    }

    public void merge(Customer c) {
        this.manager.merge((Object)c);
    }
}

