/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.service.client;

import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.tutorial.service.bean.ServiceOneRemote;
import org.jboss.tutorial.service.bean.XMBeanServiceRemote;

public class Client {
    public static void main(String[] args) throws Exception {
        InitialContext ctx = new InitialContext();
        RMIAdaptor server = (RMIAdaptor)ctx.lookup("jmx/invoker/RMIAdaptor");
        Client.invokeService(ctx, server);
        Client.invokeXMBean(ctx, server);
    }

    public static void invokeService(InitialContext ctx, RMIAdaptor server) throws Exception {
        System.out.println("invoking remote business interface of ServiceOne...");
        ServiceOneRemote serviceOne = (ServiceOneRemote)ctx.lookup("ServiceOne/remote");
        serviceOne.setAttribute(100);
        System.out.println("Set the attribute value through ServiceOneRemote to 100");
        ObjectName service1 = new ObjectName("tutorial:service=ServiceOne");
        int attr1 = (Integer)server.getAttribute(service1, "Attribute");
        System.out.println("attribute value for (ServiceOne) singleton obtained via JMX is what we set via remote interface: " + attr1);
        System.out.println("Invoking ServiceThree via JMX...");
        ObjectName service3 = new ObjectName("tutorial:service=ServiceThree");
        Object[] noArgs = new Object[]{};
        String[] noSig = new String[]{};
        String service1Hello = (String)server.invoke(service3, "serviceOneHello", noArgs, noSig);
        System.out.println(service1Hello);
        String service2Hello = (String)server.invoke(service3, "serviceTwoHello", noArgs, noSig);
        System.out.println(service2Hello);
    }

    public static void invokeXMBean(InitialContext ctx, RMIAdaptor server) throws Exception {
        System.out.println("invoking XMBean (configured through deployment descriptor)...");
        XMBeanServiceRemote xmbeanRemote = (XMBeanServiceRemote)ctx.lookup("XMBeanService/remote");
        xmbeanRemote.remoteBusinessMethodToSetAttribute(50);
        System.out.println("Set the attribute value to 50");
        System.out.println("Invoking XMBean through JMX");
        ObjectName service = new ObjectName("tutorial:service=XMBeanService");
        int attr = (Integer)server.getAttribute(service, "IntAttribute");
        System.out.println("attribute value for (XMBeanService deployment descriptor configured) singleton obtained via JMX is what we set via remote interface: " + attr);
        Object[] noArgs = new Object[]{};
        String[] noSig = new String[]{};
        String hello = (String)server.invoke(service, "sayHello", noArgs, noSig);
        System.out.println(hello);
    }
}

