/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.aop.impl.concurrency.bridge;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.ejb.Lock;
import javax.ejb.LockType;
import org.jboss.ejb3.metadata.MetaDataBridge;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;

public class LockMetaDataBridge
implements MetaDataBridge<JBossEnterpriseBeanMetaData> {
    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData metaData, ClassLoader classLoader) {
        if (annotationClass == null || !annotationClass.equals(Lock.class)) {
            return null;
        }
        if (!metaData.isSession() || !(metaData instanceof JBossSessionBean31MetaData)) {
            return null;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)metaData;
        LockType lockType = sessionBean.getLockType();
        if (lockType == null) {
            return null;
        }
        LockImpl lock = new LockImpl(lockType);
        return (A)((Annotation)annotationClass.cast(lock));
    }

    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData metaData, ClassLoader classLoader, DeclaredMethodSignature method) {
        ConcurrentMethodsMetaData concurrentMethods;
        if (annotationClass == null || !annotationClass.equals(Lock.class)) {
            return null;
        }
        if (!metaData.isSession() || !(metaData instanceof JBossSessionBean31MetaData)) {
            return null;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)metaData;
        NamedMethodMetaData namedMethod = new NamedMethodMetaData();
        namedMethod.setName(method.getName());
        if (method.getParameters() != null) {
            MethodParametersMetaData methodParams = new MethodParametersMetaData();
            methodParams.addAll(Arrays.asList(method.getParameters()));
            namedMethod.setMethodParams(methodParams);
        }
        if ((concurrentMethods = sessionBean.getConcurrentMethods()) == null) {
            return null;
        }
        ConcurrentMethodMetaData concurrentMethodMetaData = concurrentMethods.find(namedMethod);
        LockType lockType = null;
        if (concurrentMethodMetaData == null || concurrentMethodMetaData.getLockType() == null) {
            lockType = this.getLockTypeApplicableForAllMethods(sessionBean);
        }
        if (lockType == null) {
            return null;
        }
        LockImpl lock = new LockImpl(lockType);
        return (A)((Annotation)annotationClass.cast(lock));
    }

    private LockType getLockTypeApplicableForAllMethods(JBossSessionBean31MetaData sessionBean) {
        NamedMethodMetaData allMethods = new NamedMethodMetaData();
        allMethods.setName("*");
        ConcurrentMethodMetaData concurrentMethod = sessionBean.getConcurrentMethods().get(allMethods);
        if (concurrentMethod == null) {
            return null;
        }
        return concurrentMethod.getLockType();
    }

    private class LockImpl
    implements Lock {
        private LockType lockType;

        public LockImpl(LockType lockType) {
            this.lockType = lockType;
        }

        public LockType value() {
            return this.lockType;
        }

        public Class<? extends Annotation> annotationType() {
            return Lock.class;
        }
    }
}

