/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import org.jboss.dependency.spi.Controller;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.container.spi.deployment.EJB3Deployment;
import org.jboss.ejb3.singleton.impl.deployment.EJB3DeploymentImpl;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class EJB3DeploymentDeployer
extends AbstractDeployer {
    private static Logger logger = Logger.getLogger(EJB3DeploymentDeployer.class);
    private Controller kernelController;

    public EJB3DeploymentDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setInput(JBossMetaData.class);
        this.addInput(AttachmentNames.PROCESSED_METADATA);
        this.addOutput(Ejb3Deployment.class);
        this.addOutput(EJB3Deployment.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        JBossMetaData metadata = (JBossMetaData)unit.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class);
        if (!metadata.isEJB3x()) {
            return;
        }
        EJB3DeploymentImpl ejb3Deployment = new EJB3DeploymentImpl(unit.getSimpleName(), unit, metadata);
        unit.addAttachment(EJB3Deployment.class, (Object)ejb3Deployment);
    }
}

