/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.util.naming.Util;

public class JNDIBinderImpl {
    private Context context;
    private String jndiName;
    private Object jndiObject;
    private String description;

    public JNDIBinderImpl(Context ctx, String jndiName, Object objectToBind) {
        this.context = ctx;
        this.jndiName = jndiName;
        this.jndiObject = objectToBind;
    }

    public JNDIBinderImpl(Context ctx, String jndiName, Object objectToBind, String description) {
        this(ctx, jndiName, objectToBind);
        this.description = description;
    }

    @Start
    public void start() throws Exception {
        this.bind();
    }

    @Stop
    public void stop() throws Exception {
        this.unbind();
    }

    public void bind() throws NamingException {
        Util.rebind((Context)this.context, (String)this.jndiName, (Object)this.jndiObject);
    }

    public void unbind() throws NamingException {
        Util.unbind((Context)this.context, (String)this.jndiName);
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public String getDescription() {
        return this.description;
    }
}

