/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.impl.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.container.spi.EJBContainer;
import org.jboss.ejb3.container.spi.deployment.EJB3Deployment;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class EJB3DeploymentImpl
implements EJB3Deployment {
    private String name;
    private DeploymentUnit deploymentUnit;
    private JBossMetaData jbossMetaData;
    private Map<String, EJBContainer> containers = new HashMap<String, EJBContainer>();

    public EJB3DeploymentImpl(String name, DeploymentUnit deploymentUnit, JBossMetaData jbossMetaData) {
        this.name = name;
        this.deploymentUnit = deploymentUnit;
        this.jbossMetaData = jbossMetaData;
    }

    public void addContainer(EJBContainer ejbContainer) throws IllegalArgumentException {
        String ejbName = ejbContainer.getEJBName();
        if (this.containers.containsKey(ejbName)) {
            throw new IllegalArgumentException("Container for ejb named " + ejbName + " is already registered");
        }
        this.containers.put(ejbName, ejbContainer);
    }

    public EJBContainer getEJBContainer(String ejbName) {
        return this.containers.get(ejbName);
    }

    public Collection<EJBContainer> getEJBContainers() {
        return Collections.unmodifiableCollection(this.containers.values());
    }

    public void removeEJBContainer(EJBContainer ejbContainer) throws IllegalArgumentException {
        String ejbName = ejbContainer.getEJBName();
        if (!this.containers.containsKey(ejbName)) {
            throw new IllegalArgumentException("EJB container for ejb name " + ejbName + " is not registered");
        }
        this.containers.remove(ejbName);
    }

    public String getName() {
        return this.name;
    }
}

