/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timeout.ejb3_0.test.signature;

import java.lang.reflect.Method;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.imageio.spi.ServiceRegistry;
import org.jboss.ejb3.timeout.spi.TimeoutMethodCallbackRequirements;
import org.junit.Assert;
import org.junit.Test;

public class SignatureUnitTestCase {
    protected static final TimeoutMethodCallbackRequirements requirements = ServiceRegistry.lookupProviders(TimeoutMethodCallbackRequirements.class).next();

    @Test
    public void test1() {
        Class<Bean1> beanClass = Bean1.class;
        Method timeoutMethod = requirements.getTimeoutMethod(beanClass, null);
        Assert.assertNull((Object)timeoutMethod);
    }

    @Test
    public void test2() throws Exception {
        Class<Bean2> beanClass = Bean2.class;
        Method timeoutMethod = requirements.getTimeoutMethod(beanClass, null);
        Method expected = TimedObject.class.getMethod("ejbTimeout", Timer.class);
        Assert.assertEquals((Object)expected, (Object)timeoutMethod);
    }

    @Test
    public void test3() throws Exception {
        Class<Bean3> beanClass = Bean3.class;
        Method timeoutMethod = requirements.getTimeoutMethod(beanClass, "timeout");
        Method expected = Bean3.class.getMethod("timeout", Timer.class);
        Assert.assertEquals((Object)expected, (Object)timeoutMethod);
    }

    @Test
    public void test4() throws Exception {
        Class<Bean4> beanClass = Bean4.class;
        Method timeoutMethod = requirements.getTimeoutMethod(beanClass, "timeout");
        Method expected = Bean3.class.getMethod("timeout", Timer.class);
        Assert.assertEquals((Object)expected, (Object)timeoutMethod);
    }

    @Test
    public void testFinal() throws Exception {
        Class<BeanFinal> beanClass = BeanFinal.class;
        try {
            requirements.getTimeoutMethod(beanClass, "timeout");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReturnType() throws Exception {
        Class<BeanReturnType> beanClass = BeanReturnType.class;
        try {
            requirements.getTimeoutMethod(beanClass, "timeout");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStatic() throws Exception {
        Class<BeanStatic> beanClass = BeanStatic.class;
        try {
            requirements.getTimeoutMethod(beanClass, "timeout");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWrongParameterType() throws Exception {
        try {
            class Bean {
                Bean() {
                }

                @Timeout
                public void timeout(Object wrong) {
                }
            }
            requirements.getTimeoutMethod(Bean.class, "timeout");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWrongParameterCount() throws Exception {
        try {
            class Bean {
                Bean() {
                }

                @Timeout
                public void timeout(Timer timer, Object wrong) {
                }
            }
            requirements.getTimeoutMethod(Bean.class, "timeout");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class BeanStatic {
        @Timeout
        public static void timeout(Timer timer) {
        }
    }

    public static class BeanReturnType {
        @Timeout
        public Object timeout(Timer timer) {
            return null;
        }
    }

    public static class BeanFinal {
        @Timeout
        public final void timeout(Timer timer) {
        }
    }

    public static class Bean4
    extends Bean3 {
    }

    public static class Bean3 {
        @Timeout
        public void timeout(Timer timer) {
        }
    }

    public static class Bean2
    implements TimedObject {
        public void ejbTimeout(Timer timer) {
        }
    }

    public static class Bean1 {
    }
}

