/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.lifecycle;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseRequest;
import org.jboss.elasticsearch.river.jira.mgm.lifecycle.JRLifecycleCommand;

public class JRLifecycleRequest
extends JRMgmBaseRequest {
    protected JRLifecycleCommand command;

    JRLifecycleRequest() {
    }

    public JRLifecycleRequest(String riverName, JRLifecycleCommand command) {
        super(riverName);
        if (command == null) {
            throw new IllegalArgumentException("command must be provided");
        }
        this.command = command;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.command = JRLifecycleCommand.detectById(in.readVInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.command.getId());
    }

    public JRLifecycleCommand getCommand() {
        return this.command;
    }

    public void setCommand(JRLifecycleCommand command) {
        this.command = command;
    }

    public String toString() {
        return "JRLifecycleRequest [command=" + (Object)((Object)this.command) + ", riverName=" + this.riverName + "]";
    }
}

