/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.state;

import java.util.Date;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.jira.IJiraRiverMgm;
import org.jboss.elasticsearch.river.jira.mgm.TransportJRMgmBaseAction;
import org.jboss.elasticsearch.river.jira.mgm.state.JRStateRequest;
import org.jboss.elasticsearch.river.jira.mgm.state.JRStateResponse;
import org.jboss.elasticsearch.river.jira.mgm.state.NodeJRStateRequest;
import org.jboss.elasticsearch.river.jira.mgm.state.NodeJRStateResponse;

public class TransportJRStateAction
extends TransportJRMgmBaseAction<JRStateRequest, JRStateResponse, NodeJRStateRequest, NodeJRStateResponse> {
    @Inject
    public TransportJRStateAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
    }

    protected String transportAction() {
        return "jira_river/state";
    }

    @Override
    protected NodeJRStateResponse performOperationOnJiraRiver(IJiraRiverMgm river, JRStateRequest req, DiscoveryNode node) throws Exception {
        this.logger.debug("Go to get state information from river '{}'", new Object[]{req.getRiverName()});
        String ret = river.getRiverOperationInfo(node, new Date());
        return new NodeJRStateResponse(node, true, ret);
    }

    protected JRStateRequest newRequest() {
        return new JRStateRequest();
    }

    protected NodeJRStateRequest newNodeRequest() {
        return new NodeJRStateRequest();
    }

    protected NodeJRStateRequest newNodeRequest(String nodeId, JRStateRequest request) {
        return new NodeJRStateRequest(nodeId, request);
    }

    protected NodeJRStateResponse newNodeResponse() {
        return new NodeJRStateResponse(this.clusterService.localNode());
    }

    protected NodeJRStateResponse[] newNodeResponseArray(int len) {
        return new NodeJRStateResponse[len];
    }

    protected JRStateResponse newResponse(ClusterName clusterName, NodeJRStateResponse[] array) {
        return new JRStateResponse(clusterName, array);
    }
}

