/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Collection;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessor;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public abstract class StructuredContentPreprocessorBase
implements StructuredContentPreprocessor {
    protected ESLogger logger = null;
    protected String name;
    protected Client client;

    @Override
    public void init(String name, Client client, Map<String, Object> settings) throws SettingsException {
        this.logger = Loggers.getLogger(this.getClass(), (String[])new String[]{name});
        this.name = name;
        this.client = client;
        this.init(settings);
    }

    public abstract void init(Map<String, Object> var1) throws SettingsException;

    protected void validateConfigurationStringNotEmpty(String value, String configFieldName) throws SettingsException {
        if (ValueUtils.isEmpty(value)) {
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "' configuration value for '" + this.name + "' preprocessor");
        }
    }

    protected void validateConfigurationObjectNotEmpty(Object value, String configFieldName) throws SettingsException {
        if (value == null || value instanceof String && ValueUtils.isEmpty((String)value) || value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "' configuration value for '" + this.name + "' preprocessor");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

