/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class ESLookupValuePreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_index_name = "index_name";
    protected static final String CFG_index_type = "index_type";
    protected static final String CFG_source_field = "source_field";
    protected static final String CFG_source_value = "source_value";
    protected static final String CFG_idx_search_field = "idx_search_field";
    protected static final String CFG_result_mapping = "result_mapping";
    protected static final String CFG_idx_result_field = "idx_result_field";
    protected static final String CFG_target_field = "target_field";
    protected static final String CFG_value_default = "value_default";
    protected static final String CFG_source_bases = "source_bases";
    protected List<String> sourceBases;
    protected String indexName;
    protected String indexType;
    protected String sourceField;
    protected String sourceValuePattern;
    protected String idxSearchField;
    protected List<Map<String, String>> resultMapping;
    private boolean esExceptionWarned = false;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (this.client == null) {
            throw new SettingsException("ElasticSearch client is required for preprocessor " + this.name);
        }
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.indexName = XContentMapValues.nodeStringValue((Object)settings.get(CFG_index_name), null);
        this.validateConfigurationStringNotEmpty(this.indexName, CFG_index_name);
        this.indexType = XContentMapValues.nodeStringValue((Object)settings.get(CFG_index_type), null);
        this.validateConfigurationStringNotEmpty(this.indexType, CFG_index_type);
        this.sourceField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_source_field), null);
        if (ValueUtils.isEmpty(this.sourceField)) {
            this.sourceField = null;
            this.sourceValuePattern = XContentMapValues.nodeStringValue((Object)settings.get(CFG_source_value), null);
        }
        if (ValueUtils.isEmpty(this.sourceField) && ValueUtils.isEmpty(this.sourceValuePattern)) {
            throw new SettingsException("At least one of 'settings/source_field' or 'settings/source_value' configuration value must be defined for '" + this.name + "' preprocessor");
        }
        this.resultMapping = (List)settings.get(CFG_result_mapping);
        this.validateResultMappingConfiguration(this.resultMapping, CFG_result_mapping);
        this.idxSearchField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_idx_search_field), null);
        this.validateConfigurationStringNotEmpty(this.idxSearchField, CFG_idx_search_field);
        this.sourceBases = (List)settings.get(CFG_source_bases);
    }

    protected void validateResultMappingConfiguration(List<Map<String, String>> value, String configFieldName) throws SettingsException {
        if (value == null || value.isEmpty()) {
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "' configuration array for '" + this.name + "' preprocessor");
        }
        for (Map<String, String> mappingRecord : value) {
            if (ValueUtils.isEmpty(mappingRecord.get(CFG_idx_result_field))) {
                throw new SettingsException("Missing or empty 'settings/" + configFieldName + "/" + CFG_idx_result_field + "' configuration value for '" + this.name + "' preprocessor");
            }
            if (!ValueUtils.isEmpty(mappingRecord.get(CFG_target_field))) continue;
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "/" + CFG_target_field + "' configuration value for '" + this.name + "' preprocessor");
        }
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        if (this.sourceBases == null) {
            this.processOneSourceValue(data, null);
        } else {
            LookupContenxt context = new LookupContenxt();
            for (String base : this.sourceBases) {
                Object obj = XContentMapValues.extractValue((String)base, data);
                if (obj == null) continue;
                if (obj instanceof Map) {
                    this.processOneSourceValue((Map)obj, context);
                    continue;
                }
                if (obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o instanceof Map) {
                            this.processOneSourceValue((Map)o, context);
                            continue;
                        }
                        this.logger.warn("Source base {} contains collection with invalid value to be processed {}", new Object[]{base, obj});
                    }
                    continue;
                }
                this.logger.warn("Source base {} contains invalid value to be processed {}", new Object[]{base, obj});
            }
        }
        return data;
    }

    private void processOneSourceValue(Map<String, Object> data, LookupContenxt context) {
        Object sourceValue = null;
        sourceValue = this.sourceField != null ? XContentMapValues.extractValue((String)this.sourceField, data) : ValueUtils.processStringValuePatternReplacement(this.sourceValuePattern, data, null);
        Map<String, Object> targetValues = null;
        if (sourceValue instanceof Collection) {
            if (context == null) {
                context = new LookupContenxt();
            }
            Collection sourceCollection = (Collection)sourceValue;
            targetValues = new HashMap<String, Object>();
            for (Object sourceObject : sourceCollection) {
                Map<String, Object> v = this.lookupValue(sourceObject, data, context);
                if (v == null) continue;
                for (String targetField : v.keySet()) {
                    Object vo = v.get(targetField);
                    if (vo == null) continue;
                    ArrayList<Object> colTarget = (ArrayList<Object>)targetValues.get(targetField);
                    if (colTarget == null) {
                        colTarget = new ArrayList<Object>();
                        targetValues.put(targetField, colTarget);
                    }
                    colTarget.add(vo);
                }
            }
        } else {
            targetValues = this.lookupValue(sourceValue, data, context);
        }
        if (targetValues != null) {
            for (String targetField : targetValues.keySet()) {
                StructureUtils.putValueIntoMapOfMaps(data, targetField, targetValues.get(targetField));
            }
        }
    }

    protected Map<String, Object> lookupValue(Object sourceValue, Map<String, Object> data, LookupContenxt context) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        if (sourceValue != null) {
            if (context != null && context.lookupCache.containsKey(sourceValue)) {
                return context.lookupCache.get(sourceValue);
            }
            try {
                SearchRequestBuilder req = this.client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexType}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.matchQuery((String)this.idxSearchField, (Object)sourceValue)));
                for (Map<String, String> mappingRecord : this.resultMapping) {
                    req.addField(mappingRecord.get(CFG_idx_result_field));
                }
                SearchResponse resp = (SearchResponse)req.execute().actionGet();
                if (resp.getHits().getTotalHits() > 0L) {
                    if (resp.getHits().getTotalHits() > 1L) {
                        this.logger.warn("More results found for lookup over value {}", new Object[]{sourceValue});
                    }
                    SearchHit hit = resp.getHits().hits()[0];
                    for (Map<String, String> mappingRecord : this.resultMapping) {
                        Object v = hit.field(mappingRecord.get(CFG_idx_result_field)).getValue();
                        if (v == null && mappingRecord.get(CFG_value_default) != null) {
                            v = ValueUtils.processStringValuePatternReplacement(mappingRecord.get(CFG_value_default), data, sourceValue);
                        }
                        value.put(mappingRecord.get(CFG_target_field), v);
                    }
                } else {
                    this.processDefaultValues(sourceValue, data, value);
                }
                this.esExceptionWarned = false;
            }
            catch (ElasticSearchException e) {
                if (!this.esExceptionWarned) {
                    this.esExceptionWarned = true;
                    this.logger.warn("ElasticSearch lookup failed due '{}:{}' so default value is used for field instead", new Object[]{((Object)((Object)e)).getClass().getName(), e.getMessage()});
                }
                this.processDefaultValues(sourceValue, data, value);
            }
        }
        if (context != null && sourceValue != null) {
            context.lookupCache.put(sourceValue, value);
        }
        return value;
    }

    private void processDefaultValues(Object sourceValue, Map<String, Object> data, Map<String, Object> value) {
        for (Map<String, String> mappingRecord : this.resultMapping) {
            if (mappingRecord.get(CFG_value_default) != null) {
                String v = ValueUtils.processStringValuePatternReplacement(mappingRecord.get(CFG_value_default), data, sourceValue);
                value.put(mappingRecord.get(CFG_target_field), v);
                continue;
            }
            value.put(mappingRecord.get(CFG_target_field), null);
        }
    }

    private class LookupContenxt {
        Map<Object, Map<String, Object>> lookupCache = new HashMap<Object, Map<String, Object>>();

        private LookupContenxt() {
        }
    }
}

