/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.riverslist;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.jira.mgm.NodeJRMgmBaseResponse;

public class NodeListRiversResponse
extends NodeJRMgmBaseResponse {
    Set<String> jiraRiverNames;

    protected NodeListRiversResponse() {
    }

    public NodeListRiversResponse(DiscoveryNode node) {
        super(node);
    }

    public NodeListRiversResponse(DiscoveryNode node, Set<String> jiraRiverNames) {
        super(node, jiraRiverNames != null && !jiraRiverNames.isEmpty());
        this.jiraRiverNames = jiraRiverNames;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int len = in.readInt();
        if (len >= 0) {
            this.jiraRiverNames = new HashSet<String>();
            for (int i = 0; i < len; ++i) {
                this.jiraRiverNames.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.jiraRiverNames == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.jiraRiverNames.size());
            if (this.jiraRiverNames != null) {
                for (String s : this.jiraRiverNames) {
                    out.writeString(s);
                }
            }
        }
    }
}

