/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseRequest;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseResponse;
import org.jboss.elasticsearch.river.jira.mgm.NodeJRMgmBaseResponse;

public abstract class JRMgmBaseActionListener<Request extends JRMgmBaseRequest, Response extends JRMgmBaseResponse<NodeResponse>, NodeResponse extends NodeJRMgmBaseResponse>
implements ActionListener<Response> {
    protected final ESLogger logger;
    protected final RestRequest restRequest;
    protected final RestChannel restChannel;
    protected final Request actionRequest;

    public JRMgmBaseActionListener(Request actionRequest, RestRequest restRequest, RestChannel restChannel) {
        this.restRequest = restRequest;
        this.restChannel = restChannel;
        this.actionRequest = actionRequest;
        this.logger = Loggers.getLogger(this.getClass());
    }

    public void onResponse(Response response) {
        try {
            Object nodeInfo = ((JRMgmBaseResponse)((Object)response)).getSuccessNodeResponse();
            if (nodeInfo == null) {
                this.restChannel.sendResponse((RestResponse)new XContentRestResponse(this.restRequest, RestStatus.NOT_FOUND, JRMgmBaseActionListener.buildMessageDocument(this.restRequest, "No JiraRiver found for name: " + ((JRMgmBaseRequest)((Object)this.actionRequest)).getRiverName())));
            } else {
                this.handleJiraRiverResponse(nodeInfo);
            }
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    protected abstract void handleJiraRiverResponse(NodeResponse var1) throws Exception;

    public void onFailure(Throwable e) {
        try {
            this.restChannel.sendResponse((RestResponse)new XContentThrowableRestResponse(this.restRequest, e));
        }
        catch (IOException e1) {
            this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
        }
    }

    public static XContentBuilder buildMessageDocument(RestRequest restRequest, String message) throws IOException {
        XContentBuilder builder = RestXContentBuilder.restContentBuilder((RestRequest)restRequest);
        builder.startObject();
        builder.field("message", message);
        builder.endObject();
        return builder;
    }
}

