/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class ESLookupValuePreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<LookupContenxt> {
    protected static final String CFG_index_name = "index_name";
    protected static final String CFG_index_type = "index_type";
    protected static final String CFG_source_field = "source_field";
    protected static final String CFG_source_value = "source_value";
    protected static final String CFG_idx_search_field = "idx_search_field";
    protected static final String CFG_result_mapping = "result_mapping";
    protected static final String CFG_idx_result_field = "idx_result_field";
    protected static final String CFG_ignore_multiple_results = "result_multiple_ignore";
    protected static final String CFG_target_field = "target_field";
    protected static final String CFG_value_default = "value_default";
    protected String indexName;
    protected String indexType;
    protected String sourceField;
    protected String sourceValuePattern;
    protected List<String> idxSearchField;
    protected List<Map<String, String>> resultMapping;
    protected boolean ignoreMultipleResults = false;
    private boolean esExceptionWarned = false;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        super.init(settings);
        if (this.client == null) {
            throw new SettingsException("ElasticSearch client is required for preprocessor " + this.name);
        }
        this.indexName = XContentMapValues.nodeStringValue((Object)settings.get(CFG_index_name), null);
        this.validateConfigurationStringNotEmpty(this.indexName, CFG_index_name);
        this.indexType = XContentMapValues.nodeStringValue((Object)settings.get(CFG_index_type), null);
        this.validateConfigurationStringNotEmpty(this.indexType, CFG_index_type);
        this.sourceField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_source_field), null);
        if (ValueUtils.isEmpty(this.sourceField)) {
            this.sourceField = null;
            this.sourceValuePattern = XContentMapValues.nodeStringValue((Object)settings.get(CFG_source_value), null);
        }
        if (ValueUtils.isEmpty(this.sourceField) && ValueUtils.isEmpty(this.sourceValuePattern)) {
            throw new SettingsException("At least one of 'settings/source_field' or 'settings/source_value' configuration value must be defined for '" + this.name + "' preprocessor");
        }
        this.resultMapping = (List)settings.get(CFG_result_mapping);
        this.validateResultMappingConfiguration(this.resultMapping, CFG_result_mapping);
        this.idxSearchField = StructureUtils.getListOfStringValues(settings, CFG_idx_search_field);
        this.validateConfigurationObjectNotEmpty(this.idxSearchField, CFG_idx_search_field);
        this.ignoreMultipleResults = XContentMapValues.nodeBooleanValue((Object)settings.get(CFG_ignore_multiple_results), (boolean)false);
    }

    protected void validateResultMappingConfiguration(List<Map<String, String>> value, String configFieldName) throws SettingsException {
        if (value == null || value.isEmpty()) {
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "' configuration array for '" + this.name + "' preprocessor");
        }
        for (Map<String, String> mappingRecord : value) {
            if (ValueUtils.isEmpty(mappingRecord.get(CFG_idx_result_field))) {
                throw new SettingsException("Missing or empty 'settings/" + configFieldName + "/" + CFG_idx_result_field + "' configuration value for '" + this.name + "' preprocessor");
            }
            if (!ValueUtils.isEmpty(mappingRecord.get(CFG_target_field))) continue;
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "/" + CFG_target_field + "' configuration value for '" + this.name + "' preprocessor");
        }
    }

    @Override
    protected LookupContenxt createContext(Map<String, Object> data) {
        return new LookupContenxt();
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, LookupContenxt context, String base, PreprocessChainContext chainContext) {
        Object sourceValue = null;
        sourceValue = this.sourceField != null ? XContentMapValues.extractValue((String)this.sourceField, data) : ValueUtils.processStringValuePatternReplacement(this.sourceValuePattern, data, null);
        Map<String, Object> targetValues = null;
        if (sourceValue instanceof Collection) {
            if (context == null) {
                context = new LookupContenxt();
            }
            Collection sourceCollection = (Collection)sourceValue;
            targetValues = new HashMap<String, Object>();
            for (Object sourceObject : sourceCollection) {
                Map<String, Object> v = this.lookupValue(sourceObject, data, context, chainContext);
                if (v == null) continue;
                for (String targetField : v.keySet()) {
                    Object vo = v.get(targetField);
                    if (vo == null) continue;
                    ArrayList<Object> colTarget = (ArrayList<Object>)targetValues.get(targetField);
                    if (colTarget == null) {
                        colTarget = new ArrayList<Object>();
                        targetValues.put(targetField, colTarget);
                    }
                    colTarget.add(vo);
                }
            }
        } else {
            targetValues = this.lookupValue(sourceValue, data, context, chainContext);
        }
        if (targetValues != null) {
            for (String targetField : targetValues.keySet()) {
                StructureUtils.putValueIntoMapOfMaps(data, targetField, targetValues.get(targetField));
            }
        }
    }

    protected Map<String, Object> lookupValue(Object sourceValue, Map<String, Object> data, LookupContenxt context, PreprocessChainContext chainContext) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        if (sourceValue != null) {
            if (context != null && context.lookupCache.containsKey(sourceValue)) {
                return context.lookupCache.get(sourceValue);
            }
            boolean found = false;
            for (String idxSf : this.idxSearchField) {
                try {
                    SearchRequestBuilder req = this.client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexType}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.matchQuery((String)idxSf, (Object)sourceValue)));
                    for (Map<String, String> mappingRecord : this.resultMapping) {
                        String idx_resultField = mappingRecord.get(CFG_idx_result_field);
                        if (idx_resultField == null || "_source".equals(idx_resultField)) continue;
                        req.addField(mappingRecord.get(CFG_idx_result_field));
                    }
                    SearchResponse resp = (SearchResponse)req.execute().actionGet();
                    if (resp.getHits().getTotalHits() > 0L) {
                        if (resp.getHits().getTotalHits() > 1L) {
                            String message = "More results found during lookup for value '" + sourceValue + "' using index field '" + idxSf;
                            message = this.ignoreMultipleResults ? message + "', so we ignore them." : message + "', so first one is used.";
                            this.addDataWarning(chainContext, message);
                            this.logger.debug(message, new Object[0]);
                            if (this.ignoreMultipleResults) continue;
                        }
                        SearchHit hit = resp.getHits().hits()[0];
                        for (Map<String, String> mappingRecord : this.resultMapping) {
                            String idx_resultField = mappingRecord.get(CFG_idx_result_field);
                            Object v = null;
                            SearchHitField shf = null;
                            if ("_source".equals(idx_resultField)) {
                                v = hit.getSource();
                            } else {
                                shf = hit.field(idx_resultField);
                                if (shf != null) {
                                    v = shf.getValue();
                                }
                            }
                            if (shf != null || v != null) {
                                if (v == null && mappingRecord.get(CFG_value_default) != null) {
                                    v = ValueUtils.processStringValuePatternReplacement(mappingRecord.get(CFG_value_default), data, sourceValue);
                                }
                                value.put(mappingRecord.get(CFG_target_field), v);
                                continue;
                            }
                            String message = "Result found during lookup for value '" + sourceValue + "' using index field '" + idxSf + ", but result field '" + mappingRecord.get(CFG_idx_result_field) + "' is not present there";
                            this.addDataWarning(chainContext, message);
                            this.logger.debug(message, new Object[0]);
                        }
                        found = true;
                    } else {
                        this.addDataWarning(chainContext, "No result found during lookup for value '" + sourceValue + "'.");
                    }
                    this.esExceptionWarned = false;
                }
                catch (ElasticSearchException e) {
                    if (this.esExceptionWarned) continue;
                    this.esExceptionWarned = true;
                    String message = "Lookup failed due '" + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage() + "', so default value handling is used.";
                    this.addDataWarning(chainContext, message);
                    this.logger.warn(message, new Object[0]);
                }
            }
            if (!found) {
                this.processDefaultValues(sourceValue, data, value, chainContext);
            }
        }
        if (context != null && sourceValue != null) {
            context.lookupCache.put(sourceValue, value);
        }
        return value;
    }

    private void processDefaultValues(Object sourceValue, Map<String, Object> data, Map<String, Object> value, PreprocessChainContext chainContext) {
        for (Map<String, String> mappingRecord : this.resultMapping) {
            if (mappingRecord.get(CFG_value_default) != null) {
                String v = ValueUtils.processStringValuePatternReplacement(mappingRecord.get(CFG_value_default), data, sourceValue);
                value.put(mappingRecord.get(CFG_target_field), v);
                continue;
            }
            value.put(mappingRecord.get(CFG_target_field), null);
        }
    }

    @Override
    public List<String> getSourceBases() {
        return this.sourceBases;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public String getSourceValuePattern() {
        return this.sourceValuePattern;
    }

    public List<String> getIdxSearchField() {
        return this.idxSearchField;
    }

    public List<Map<String, String>> getResultMapping() {
        return this.resultMapping;
    }

    protected class LookupContenxt {
        Map<Object, Map<String, Object>> lookupCache = new HashMap<Object, Map<String, Object>>();

        protected LookupContenxt() {
        }
    }
}

