/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.jira.IJiraRiverMgm;
import org.jboss.elasticsearch.river.jira.JiraRiver;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseRequest;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseResponse;
import org.jboss.elasticsearch.river.jira.mgm.NodeJRMgmBaseRequest;
import org.jboss.elasticsearch.river.jira.mgm.NodeJRMgmBaseResponse;

public abstract class TransportJRMgmBaseAction<Request extends JRMgmBaseRequest, Response extends JRMgmBaseResponse, NodeRequest extends NodeJRMgmBaseRequest<Request>, NodeResponse extends NodeJRMgmBaseResponse>
extends TransportNodesOperationAction<Request, Response, NodeRequest, NodeResponse> {
    protected final ESLogger logger = Loggers.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public TransportJRMgmBaseAction(Settings settings, String actionName, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, actionName, clusterName, threadPool, clusterService, transportService);
    }

    protected String executor() {
        return "management";
    }

    protected Response newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeJRMgmBaseResponse> nodesInfos = new ArrayList<NodeJRMgmBaseResponse>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeJRMgmBaseResponse)) continue;
            nodesInfos.add((NodeJRMgmBaseResponse)((Object)resp));
        }
        return (Response)((Object)this.newResponse(this.clusterName, nodesInfos.toArray(this.newNodeResponseArray(nodesInfos.size()))));
    }

    protected abstract NodeResponse[] newNodeResponseArray(int var1);

    protected abstract Response newResponse(ClusterName var1, NodeResponse[] var2);

    protected boolean accumulateExceptions() {
        return false;
    }

    protected NodeResponse nodeOperation(NodeRequest nodeRequest) throws ElasticsearchException {
        Object req = ((NodeJRMgmBaseRequest)((Object)nodeRequest)).getRequest();
        this.logger.debug("Go to look for river '{}' on this node", new Object[]{((JRMgmBaseRequest)((Object)req)).getRiverName()});
        IJiraRiverMgm river = JiraRiver.getRunningInstance(((JRMgmBaseRequest)((Object)req)).getRiverName());
        if (river == null) {
            this.logger.debug("JIRA River {} not found on this node", new Object[]{((JRMgmBaseRequest)((Object)req)).getRiverName()});
            return (NodeResponse)((Object)((NodeJRMgmBaseResponse)this.newNodeResponse()));
        }
        this.logger.debug("JIRA River {} found on this node, go to call mgm operation on it {}", new Object[]{((JRMgmBaseRequest)((Object)req)).getRiverName(), req});
        try {
            return this.performOperationOnJiraRiver(river, req, this.clusterService.localNode());
        }
        catch (Exception e) {
            throw new ElasticsearchException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract NodeResponse performOperationOnJiraRiver(IJiraRiverMgm var1, Request var2, DiscoveryNode var3) throws Exception;
}

