/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.lifecycle;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseActionListener;
import org.jboss.elasticsearch.river.jira.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.jira.mgm.lifecycle.JRLifecycleAction;
import org.jboss.elasticsearch.river.jira.mgm.lifecycle.JRLifecycleCommand;
import org.jboss.elasticsearch.river.jira.mgm.lifecycle.JRLifecycleRequest;
import org.jboss.elasticsearch.river.jira.mgm.lifecycle.JRLifecycleResponse;
import org.jboss.elasticsearch.river.jira.mgm.lifecycle.NodeJRLifecycleResponse;

public class RestJRLifecycleAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestJRLifecycleAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        String baseUrl = this.baseRestMgmUrl();
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "stop", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "restart", (RestHandler)this);
    }

    public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) {
        JRLifecycleCommand command = JRLifecycleCommand.RESTART;
        if (restRequest.path().endsWith("stop")) {
            command = JRLifecycleCommand.STOP;
        }
        JRLifecycleRequest actionRequest = new JRLifecycleRequest(restRequest.param("riverName"), command);
        client.admin().cluster().execute((Action)JRLifecycleAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new JRMgmBaseActionListener<JRLifecycleRequest, JRLifecycleResponse, NodeJRLifecycleResponse>(actionRequest, restRequest, restChannel){

            @Override
            protected void handleJiraRiverResponse(NodeJRLifecycleResponse nodeInfo) throws Exception {
                this.restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, 1.buildMessageDocument(this.restRequest, "Command successful")));
            }
        });
    }
}

