/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.fullupdate;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseActionListener;
import org.jboss.elasticsearch.river.jira.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.FullUpdateAction;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.FullUpdateRequest;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.FullUpdateResponse;
import org.jboss.elasticsearch.river.jira.mgm.fullupdate.NodeFullUpdateResponse;

public class RestFullUpdateAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestFullUpdateAction(Settings settings, Client client, RestController controller) {
        super(settings, controller, client);
        String baseUrl = this.baseRestMgmUrl();
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "fullupdate", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "fullupdate/{projectKey}", (RestHandler)this);
    }

    public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) {
        final String riverName = restRequest.param("riverName");
        final String projectKey = restRequest.param("projectKey");
        FullUpdateRequest actionRequest = new FullUpdateRequest(riverName, projectKey);
        client.admin().cluster().execute((Action)FullUpdateAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new JRMgmBaseActionListener<FullUpdateRequest, FullUpdateResponse, NodeFullUpdateResponse>(actionRequest, restRequest, restChannel){

            @Override
            protected void handleJiraRiverResponse(NodeFullUpdateResponse nodeInfo) throws Exception {
                if (((FullUpdateRequest)this.actionRequest).isProjectKeyRequest() && !nodeInfo.projectFound) {
                    this.restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, 1.buildMessageDocument(this.restRequest, "Project '" + projectKey + "' is not indexed by JiraRiver with name: " + riverName)));
                } else {
                    this.restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, 1.buildMessageDocument(this.restRequest, "Scheduled full reindex for JIRA projects: " + nodeInfo.reindexedProjectNames)));
                }
            }
        });
    }
}

