/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.ISpaceIndexerCoordinator;
import org.jboss.elasticsearch.river.remote.SpaceByLastUpdateTimestampIndexer;
import org.jboss.elasticsearch.river.remote.SpaceIndexingInfo;

public class SpaceIndexerCoordinator
implements ISpaceIndexerCoordinator {
    private static final ESLogger logger = Loggers.getLogger(SpaceIndexerCoordinator.class);
    protected static final String STORE_PROPERTYNAME_LAST_INDEX_UPDATE_START_DATE = "lastIndexUpdateStartDate";
    protected static final String STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE = "lastIndexFullUpdateDate";
    protected static final String STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE = "forceIndexFullUpdateDate";
    protected static final int COORDINATOR_THREAD_WAITS_QUICK = 2000;
    protected static final int COORDINATOR_THREAD_WAITS_SLOW = 30000;
    protected int coordinatorThreadWaits = 2000;
    protected IESIntegration esIntegrationComponent;
    protected IRemoteSystemClient remoteSystemClient;
    protected IDocumentIndexStructureBuilder documentIndexStructureBuilder;
    protected int maxIndexingThreads;
    protected long indexUpdatePeriod;
    protected long indexFullUpdatePeriod = -1L;
    protected Queue<String> spaceKeysToIndexQueue = new LinkedBlockingQueue<String>();
    protected final Map<String, Thread> spaceIndexerThreads = new HashMap<String, Thread>();
    protected final Map<String, SpaceByLastUpdateTimestampIndexer> spaceIndexers = new HashMap<String, SpaceByLastUpdateTimestampIndexer>();
    protected long lastQueueFillTime = 0L;

    public SpaceIndexerCoordinator(IRemoteSystemClient remoteSystemClient, IESIntegration esIntegrationComponent, IDocumentIndexStructureBuilder documentIndexStructureBuilder, long indexUpdatePeriod, int maxIndexingThreads, long indexFullUpdatePeriod) {
        this.remoteSystemClient = remoteSystemClient;
        this.esIntegrationComponent = esIntegrationComponent;
        this.indexUpdatePeriod = indexUpdatePeriod;
        this.maxIndexingThreads = maxIndexingThreads;
        this.documentIndexStructureBuilder = documentIndexStructureBuilder;
        this.indexFullUpdatePeriod = indexFullUpdatePeriod;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void processLoopTask() throws Exception, InterruptedException {
        long now = System.currentTimeMillis();
        if (this.spaceKeysToIndexQueue.isEmpty() || this.lastQueueFillTime < now - 30000L) {
            this.lastQueueFillTime = now;
            this.fillSpaceKeysToIndexQueue();
        }
        if (this.spaceKeysToIndexQueue.isEmpty()) {
            this.coordinatorThreadWaits = 30000;
        } else {
            this.coordinatorThreadWaits = 2000;
            this.startIndexers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillSpaceKeysToIndexQueue() throws Exception, InterruptedException {
        List<String> ap = this.esIntegrationComponent.getAllIndexedSpaceKeys();
        if (ap != null && !ap.isEmpty()) {
            for (String spaceKey : ap) {
                if (this.esIntegrationComponent.isClosed()) {
                    throw new InterruptedException();
                }
                Map<String, Thread> map = this.spaceIndexerThreads;
                synchronized (map) {
                    if (this.spaceIndexerThreads.containsKey(spaceKey)) {
                        continue;
                    }
                }
                if (this.spaceKeysToIndexQueue.contains(spaceKey) || !this.spaceIndexUpdateNecessary(spaceKey)) continue;
                this.spaceKeysToIndexQueue.add(spaceKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startIndexers() throws InterruptedException, Exception {
        String firstSkippedFullIndex = null;
        while (this.spaceIndexerThreads.size() < this.maxIndexingThreads && !this.spaceKeysToIndexQueue.isEmpty()) {
            if (this.esIntegrationComponent.isClosed()) {
                throw new InterruptedException();
            }
            String spaceKey = this.spaceKeysToIndexQueue.poll();
            boolean fullUpdateNecessary = this.spaceIndexFullUpdateNecessary(spaceKey);
            if (fullUpdateNecessary && this.maxIndexingThreads > 1 && this.spaceIndexerThreads.size() == this.maxIndexingThreads - 1) {
                this.spaceKeysToIndexQueue.add(spaceKey);
                if (firstSkippedFullIndex == null) {
                    firstSkippedFullIndex = spaceKey;
                    continue;
                }
                if (firstSkippedFullIndex != spaceKey) continue;
                return;
            }
            SpaceByLastUpdateTimestampIndexer indexer = new SpaceByLastUpdateTimestampIndexer(spaceKey, fullUpdateNecessary, this.remoteSystemClient, this.esIntegrationComponent, this.documentIndexStructureBuilder);
            Thread it = this.esIntegrationComponent.acquireIndexingThread("remote_river_indexer_" + spaceKey, indexer);
            this.esIntegrationComponent.storeDatetimeValue(spaceKey, STORE_PROPERTYNAME_LAST_INDEX_UPDATE_START_DATE, new Date(), null);
            Map<String, Thread> map = this.spaceIndexerThreads;
            synchronized (map) {
                this.spaceIndexerThreads.put(spaceKey, it);
                this.spaceIndexers.put(spaceKey, indexer);
            }
            it.start();
        }
    }

    protected boolean spaceIndexUpdateNecessary(String spaceKey) throws Exception {
        Date lastIndexing = this.esIntegrationComponent.readDatetimeValue(spaceKey, STORE_PROPERTYNAME_LAST_INDEX_UPDATE_START_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug("Space {} last indexing start date is {}. We perform next indexing after {}ms.", new Object[]{spaceKey, lastIndexing, this.indexUpdatePeriod});
        }
        return lastIndexing == null || lastIndexing.getTime() < System.currentTimeMillis() - this.indexUpdatePeriod;
    }

    protected boolean spaceIndexFullUpdateNecessary(String spaceKey) throws Exception {
        if (this.esIntegrationComponent.readDatetimeValue(spaceKey, STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE) != null) {
            return true;
        }
        if (this.indexFullUpdatePeriod < 1L) {
            return false;
        }
        Date lastIndexing = this.esIntegrationComponent.readDatetimeValue(spaceKey, STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug("Space {} last full update date is {}. We perform next full indexing after {}ms.", new Object[]{spaceKey, lastIndexing, this.indexFullUpdatePeriod});
        }
        return lastIndexing == null || lastIndexing.getTime() < System.currentTimeMillis() - this.indexFullUpdatePeriod;
    }

    @Override
    public void forceFullReindex(String spaceKey) throws Exception {
        this.esIntegrationComponent.storeDatetimeValue(spaceKey, STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE, new Date(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportIndexingFinished(String spaceKey, boolean finishedOK, boolean fullUpdate) {
        Map<String, Thread> map = this.spaceIndexerThreads;
        synchronized (map) {
            this.spaceIndexerThreads.remove(spaceKey);
            this.spaceIndexers.remove(spaceKey);
        }
        if (finishedOK && fullUpdate) {
            try {
                this.esIntegrationComponent.storeDatetimeValue(spaceKey, STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE, new Date(), null);
            }
            catch (Exception e) {
                logger.error("Can't store {} value due: {}", new Object[]{STORE_PROPERTYNAME_LAST_INDEX_FULL_UPDATE_DATE, e.getMessage()});
            }
            try {
                this.esIntegrationComponent.deleteDatetimeValue(spaceKey, STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE);
            }
            catch (Exception e) {
                logger.error("Can't store {} value due: {}", new Object[]{STORE_PROPERTYNAME_FORCE_INDEX_FULL_UPDATE_DATE, e.getMessage()});
            }
        }
    }

    public void setIndexFullUpdatePeriod(int indexFullUpdatePeriod) {
        this.indexFullUpdatePeriod = indexFullUpdatePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpaceIndexingInfo> getCurrentSpaceIndexingInfo() {
        ArrayList<SpaceIndexingInfo> ret = new ArrayList<SpaceIndexingInfo>();
        Map<String, Thread> map = this.spaceIndexerThreads;
        synchronized (map) {
            for (SpaceByLastUpdateTimestampIndexer indexer : this.spaceIndexers.values()) {
                ret.add(indexer.getIndexingInfo());
            }
        }
        return ret;
    }
}

