/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.state;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.ClusterAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.jboss.elasticsearch.river.remote.mgm.JRMgmBaseActionListener;
import org.jboss.elasticsearch.river.remote.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.remote.mgm.state.JRStateAction;
import org.jboss.elasticsearch.river.remote.mgm.state.JRStateRequest;
import org.jboss.elasticsearch.river.remote.mgm.state.JRStateResponse;
import org.jboss.elasticsearch.river.remote.mgm.state.NodeJRStateResponse;

public class RestJRStateAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestJRStateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        String baseUrl = this.baseRestMgmUrl();
        controller.registerHandler(RestRequest.Method.GET, baseUrl + "state", (RestHandler)this);
    }

    public void handleRequest(RestRequest restRequest, RestChannel restChannel) {
        JRStateRequest actionRequest = new JRStateRequest(restRequest.param("riverName"));
        this.client.admin().cluster().execute((ClusterAction)JRStateAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new JRMgmBaseActionListener<JRStateRequest, JRStateResponse, NodeJRStateResponse>(actionRequest, restRequest, restChannel){

            @Override
            protected void handleRiverResponse(NodeJRStateResponse nodeInfo) throws Exception {
                this.restChannel.sendResponse((RestResponse)new BytesRestResponse(nodeInfo.stateInformation.getBytes(), XContentType.JSON.restContentType()));
            }
        });
    }
}

