/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.riverslist;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.remote.mgm.NodeJRMgmBaseResponse;

public class NodeListRiversResponse
extends NodeJRMgmBaseResponse {
    Set<String> riverNames;

    protected NodeListRiversResponse() {
    }

    public NodeListRiversResponse(DiscoveryNode node) {
        super(node);
    }

    public NodeListRiversResponse(DiscoveryNode node, Set<String> riverNames) {
        super(node, riverNames != null && !riverNames.isEmpty());
        this.riverNames = riverNames;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int len = in.readInt();
        if (len >= 0) {
            this.riverNames = new HashSet<String>();
            for (int i = 0; i < len; ++i) {
                this.riverNames.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.riverNames == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.riverNames.size());
            if (this.riverNames != null) {
                for (String s : this.riverNames) {
                    out.writeString(s);
                }
            }
        }
    }
}

