/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.river.remote.ChangedDocumentsResults;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IPwdLoader;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.Utils;

public class GetJSONClient
implements IRemoteSystemClient {
    protected static final String CFG_GET_DOCS_RES_FIELD_TOTALCOUNT = "getDocsResFieldTotalcount";
    protected static final String CFG_GET_DOCS_RES_FIELD_DOCUMENTS = "getDocsResFieldDocuments";
    protected static final String CFG_PASSWORD = "pwd";
    protected static final String CFG_USERNAME = "username";
    protected static final String CFG_TIMEOUT = "timeout";
    protected static final String CFG_GET_SPACES_RESPONSE_FIELD = "getSpacesResField";
    protected static final String CFG_URL_GET_SPACES = "urlGetSpaces";
    protected static final String CFG_URL_GET_DOCUMENTS = "urlGetDocuments";
    protected static final String CFG_URL_GET_DOCUMENT_DETAILS = "urlGetDocumentDetails";
    private static final ESLogger logger = Loggers.getLogger(GetJSONClient.class);
    private DefaultHttpClient httpclient;
    protected String urlGetSpaces;
    protected String getSpacesResField;
    protected String getDocsResFieldDocuments;
    protected String getDocsResFieldTotalcount;
    protected String urlGetDocuments;
    protected String urlGetDocumentDetails;
    protected boolean isAuthConfigured = false;
    protected IDocumentIndexStructureBuilder indexStructureBuilder;

    @Override
    public void init(Map<String, Object> config, boolean spaceListLoadingEnabled, IPwdLoader pwdLoader) {
        this.urlGetDocuments = this.getUrlFromConfig(config, CFG_URL_GET_DOCUMENTS, true);
        this.urlGetDocumentDetails = this.getUrlFromConfig(config, CFG_URL_GET_DOCUMENT_DETAILS, false);
        this.getDocsResFieldDocuments = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_GET_DOCS_RES_FIELD_DOCUMENTS), null));
        this.getDocsResFieldTotalcount = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_GET_DOCS_RES_FIELD_TOTALCOUNT), null));
        if (spaceListLoadingEnabled) {
            this.urlGetSpaces = this.getUrlFromConfig(config, CFG_URL_GET_SPACES, true);
            this.getSpacesResField = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_GET_SPACES_RESPONSE_FIELD), null));
        }
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(20);
        this.httpclient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpParams params = this.httpclient.getParams();
        params.setParameter("http.protocol.content-charset", (Object)"UTF-8");
        Integer timeout = new Long(Utils.parseTimeValue(config, CFG_TIMEOUT, 5L, TimeUnit.SECONDS)).intValue();
        if (timeout != null) {
            params.setParameter("http.socket.timeout", (Object)timeout);
            params.setParameter("http.connection.timeout", (Object)timeout);
        }
        String remoteUsername = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_USERNAME), null));
        String remotePassword = XContentMapValues.nodeStringValue((Object)config.get(CFG_PASSWORD), null);
        if (remoteUsername != null) {
            if (remotePassword == null && pwdLoader != null) {
                remotePassword = pwdLoader.loadPassword(remoteUsername);
            }
            if (remotePassword != null) {
                try {
                    URL urlGetDocumentsUrl = new URL(this.urlGetDocuments);
                    String host = urlGetDocumentsUrl.getHost();
                    this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(remoteUsername, remotePassword));
                    this.isAuthConfigured = true;
                }
                catch (MalformedURLException e) {}
            } else {
                logger.warn("Password not found so authentication is not used!", new Object[0]);
                remoteUsername = null;
            }
        } else {
            remoteUsername = null;
        }
        logger.info("Configured GET JSON remote client. Spaces listing URL '{}', documents listing url '{}', document detail url '{}', remote system user '{}'.", new Object[]{this.urlGetSpaces != null ? this.urlGetSpaces : "unused", this.urlGetDocuments, this.urlGetDocumentDetails != null ? this.urlGetDocumentDetails : "", remoteUsername != null ? remoteUsername : "Anonymous access"});
    }

    private String getUrlFromConfig(Map<String, Object> config, String cfgProperyName, boolean mandatory) {
        String url = XContentMapValues.nodeStringValue((Object)config.get(cfgProperyName), null);
        if (mandatory && Utils.isEmpty(url)) {
            throw new SettingsException("remote/" + cfgProperyName + " element of configuration structure not found or empty");
        }
        if ((url = Utils.trimToNull(url)) != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new SettingsException("Parameter remote/" + cfgProperyName + " is malformed URL " + e.getMessage());
            }
        }
        return url;
    }

    @Override
    public List<String> getAllSpaces() throws Exception {
        ArrayList<String> ret;
        block9: {
            byte[] responseData = this.performGetRESTCall(this.urlGetSpaces);
            logger.debug("Get Spaces REST response data: {}", new Object[]{new String(responseData)});
            Object responseParsed = this.parseJSONResponse(responseData);
            ret = new ArrayList<String>();
            if (this.getSpacesResField != null) {
                if (responseParsed instanceof Map) {
                    responseParsed = XContentMapValues.extractValue((String)this.getSpacesResField, (Map)((Map)responseParsed));
                } else {
                    throw new Exception("Get Spaces REST response structure is unsupported (we need a Map to take configured getSpacesResponseField from it) " + responseParsed);
                }
            }
            try {
                if (responseParsed instanceof List) {
                    List l = (List)responseParsed;
                    for (Object s : l) {
                        ret.add(s.toString());
                    }
                    break block9;
                }
                if (responseParsed instanceof Map) {
                    Map l = (Map)responseParsed;
                    for (String s : l.keySet()) {
                        ret.add(s);
                    }
                    break block9;
                }
                throw new Exception("Get Spaces REST response structure is unsupported " + responseParsed);
            }
            catch (ClassCastException e) {
                throw new Exception("Get Spaces REST response structure is unsupported " + responseParsed);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object parseJSONResponse(byte[] responseData) throws UnsupportedEncodingException, IOException {
        XContentParser parser = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("{ \"wrapit\" : ").append(new String(responseData, "UTF-8")).append("}");
            responseData = sb.toString().getBytes("UTF-8");
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(responseData);
            Map wrappedResponseParsed = parser.mapAndClose();
            Object v = wrappedResponseParsed.get("wrapit");
            return v;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Override
    public Object getChangedDocumentDetails(String spaceKey, String documentId) throws Exception {
        if (this.urlGetDocumentDetails == null) {
            return null;
        }
        String url = GetJSONClient.enhanceUrlGetDocumentDetails(this.urlGetDocumentDetails, spaceKey, documentId);
        byte[] responseData = this.performGetRESTCall(url);
        return this.parseJSONResponse(responseData);
    }

    protected static String enhanceUrlGetDocumentDetails(String url, String spaceKey, String documentId) throws UnsupportedEncodingException {
        url = url.replaceAll("\\{space\\}", URLEncoder.encode(spaceKey, "UTF-8"));
        url = url.replaceAll("\\{id\\}", URLEncoder.encode(documentId, "UTF-8"));
        return url;
    }

    @Override
    public ChangedDocumentsResults getChangedDocuments(String spaceKey, int startAt, Date updatedAfter) throws Exception {
        String url = GetJSONClient.enhanceUrlGetDocuments(this.urlGetDocuments, spaceKey, updatedAfter, startAt);
        byte[] responseData = this.performGetRESTCall(url);
        logger.debug("Get Documents REST response data: {}", new Object[]{new String(responseData)});
        try {
            Object responseParsed = this.parseJSONResponse(responseData);
            Integer total = null;
            if (this.getDocsResFieldTotalcount != null) {
                Object totalObj = XContentMapValues.extractValue((String)this.getDocsResFieldTotalcount, (Map)((Map)responseParsed));
                if (totalObj != null) {
                    if (totalObj instanceof Integer) {
                        total = (Integer)totalObj;
                    } else {
                        try {
                            total = Integer.parseInt(totalObj.toString());
                        }
                        catch (NumberFormatException e) {
                            throw new Exception("Value from configured getDocsResFieldTotalcount field is not convertable to number: " + totalObj);
                        }
                    }
                } else {
                    throw new Exception("Configured getDocsResFieldTotalcount field has no value");
                }
            }
            List documents = null;
            documents = this.getDocsResFieldDocuments != null ? (List)XContentMapValues.extractValue((String)this.getDocsResFieldDocuments, (Map)((Map)responseParsed)) : (List)responseParsed;
            return new ChangedDocumentsResults(documents, startAt, total);
        }
        catch (ClassCastException e) {
            throw new Exception("Get Documents REST response structure is invalid " + responseData);
        }
    }

    protected static String enhanceUrlGetDocuments(String url, String spaceKey, Date updatedAfter, int startAt) throws UnsupportedEncodingException {
        url = url.replaceAll("\\{space\\}", URLEncoder.encode(spaceKey, "UTF-8"));
        url = url.replaceAll("\\{updatedAfter\\}", updatedAfter != null ? updatedAfter.getTime() + "" : "");
        url = url.replaceAll("\\{startAtIndex\\}", startAt + "");
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] performGetRESTCall(String url) throws Exception {
        logger.debug("Going to perform remote system HTTP GET REST API call to the the {}", new Object[]{url});
        URIBuilder builder = new URIBuilder(url);
        HttpGet method = new HttpGet(builder.build());
        method.addHeader("Accept", "application/json");
        try {
            HttpHost targetHost = new HttpHost(builder.getHost(), builder.getPort(), builder.getScheme());
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            BasicHttpContext localcontext = new BasicHttpContext();
            localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            HttpResponse response = this.httpclient.execute((HttpUriRequest)method, (HttpContext)localcontext);
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] responseContent = null;
            if (response.getEntity() != null) {
                responseContent = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            if (statusCode != 200) {
                throw new Exception("Failed remote system REST API call to the url '" + url + "'. HTTP error code: " + statusCode + " Response body: " + new String(responseContent));
            }
            byte[] byArray = responseContent;
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void setIndexStructureBuilder(IDocumentIndexStructureBuilder indexStructureBuilder) {
        this.indexStructureBuilder = indexStructureBuilder;
    }

    @Override
    public IDocumentIndexStructureBuilder getIndexStructureBuilder() {
        return this.indexStructureBuilder;
    }
}

