/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.river.remote.ChangedDocumentsResults;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.SpaceIndexingInfo;
import org.jboss.elasticsearch.river.remote.exception.RemoteDocumentNotFoundException;

public class SpaceByLastUpdateTimestampIndexer
implements Runnable {
    private static final ESLogger logger = Loggers.getLogger(SpaceByLastUpdateTimestampIndexer.class);
    protected static final String STORE_PROPERTYNAME_LAST_INDEXED_DOC_UPDATE_DATE = "lastIndexedDocumentUpdateDate";
    protected final IRemoteSystemClient remoteSystemClient;
    protected final IESIntegration esIntegrationComponent;
    protected final IDocumentIndexStructureBuilder documentIndexStructureBuilder;
    protected final String spaceKey;
    protected boolean simpleGetDocuments;
    protected long startTime = 0L;
    protected SpaceIndexingInfo indexingInfo;

    public SpaceByLastUpdateTimestampIndexer(String spaceKey, boolean fullUpdate, boolean simpleGetDocuments, IRemoteSystemClient remoteSystemClient, IESIntegration esIntegrationComponent, IDocumentIndexStructureBuilder documentIndexStructureBuilder) {
        if (spaceKey == null || spaceKey.trim().length() == 0) {
            throw new IllegalArgumentException("spaceKey must be defined");
        }
        this.remoteSystemClient = remoteSystemClient;
        this.spaceKey = spaceKey;
        this.esIntegrationComponent = esIntegrationComponent;
        this.documentIndexStructureBuilder = documentIndexStructureBuilder;
        this.simpleGetDocuments = simpleGetDocuments;
        if (simpleGetDocuments) {
            fullUpdate = true;
        }
        this.indexingInfo = new SpaceIndexingInfo(spaceKey, fullUpdate);
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.indexingInfo.startDate = new Date(this.startTime);
        try {
            this.processUpdate();
            this.processDelete(new Date(this.startTime));
            this.indexingInfo.timeElapsed = System.currentTimeMillis() - this.startTime;
            this.indexingInfo.finishedOK = true;
            this.esIntegrationComponent.reportIndexingFinished(this.indexingInfo);
            logger.info("Finished {} update for Space {}. {} updated and {} deleted documents. Time elapsed {}s.", new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.spaceKey, this.indexingInfo.documentsUpdated, this.indexingInfo.documentsDeleted, this.indexingInfo.timeElapsed / 1000L});
        }
        catch (Throwable e) {
            this.indexingInfo.timeElapsed = System.currentTimeMillis() - this.startTime;
            this.indexingInfo.errorMessage = e.getMessage();
            this.indexingInfo.finishedOK = false;
            this.esIntegrationComponent.reportIndexingFinished(this.indexingInfo);
            Throwable cause = e;
            if (cause instanceof IOException || cause instanceof InterruptedException) {
                cause = null;
            }
            logger.error("Failed {} update for Space {} due: {}", cause, new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.spaceKey, e.getMessage()});
        }
    }

    protected void processUpdate() throws Exception {
        this.indexingInfo.documentsUpdated = 0;
        Date updatedAfter = null;
        if (!this.indexingInfo.fullUpdate) {
            updatedAfter = this.readLastDocumentUpdatedDate(this.spaceKey);
        }
        Date updatedAfterStarting = updatedAfter;
        if (updatedAfter == null) {
            this.indexingInfo.fullUpdate = true;
        }
        Date lastDocumentUpdatedDate = null;
        int startAt = 0;
        logger.info("Go to perform {} update for Space {}", new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.spaceKey});
        boolean cont = true;
        while (cont) {
            ChangedDocumentsResults res;
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Go to ask remote system for updated documents for space {} with startAt {} and updated {}", new Object[]{this.spaceKey, startAt, updatedAfter != null ? "after " + updatedAfter : "in whole history"});
            }
            if ((res = this.remoteSystemClient.getChangedDocuments(this.spaceKey, startAt, updatedAfter)).getDocumentsCount() == 0) {
                cont = false;
                continue;
            }
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            Date firstDocumentUpdatedDate = null;
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            for (Map<String, Object> document : res.getDocuments()) {
                String documentId;
                block19: {
                    documentId = this.documentIndexStructureBuilder.extractDocumentId(document);
                    if (documentId == null) {
                        throw new IllegalArgumentException("Document ID not found in remote system response for Space " + this.spaceKey + " within data: " + document);
                    }
                    try {
                        Object detail = this.remoteSystemClient.getChangedDocumentDetails(this.spaceKey, documentId, document);
                        if (detail == null) break block19;
                        document.put("detail", detail);
                    }
                    catch (RemoteDocumentNotFoundException e) {
                        logger.warn("Document '{}' details not found on server, so skip it: " + e.getMessage(), new Object[]{documentId});
                        continue;
                    }
                }
                lastDocumentUpdatedDate = this.documentIndexStructureBuilder.extractDocumentUpdated(document);
                logger.debug("Go to update index for document '{}' with updated {}", new Object[]{documentId, lastDocumentUpdatedDate});
                if (!this.simpleGetDocuments && lastDocumentUpdatedDate == null) {
                    throw new IllegalArgumentException("Last update timestamp not found in data for document " + documentId);
                }
                if (firstDocumentUpdatedDate == null) {
                    firstDocumentUpdatedDate = lastDocumentUpdatedDate;
                }
                this.documentIndexStructureBuilder.indexDocument(esBulk, this.spaceKey, document);
                ++this.indexingInfo.documentsUpdated;
                if (!this.isClosed()) continue;
                throw new InterruptedException("Interrupted because River is closed");
            }
            if (!this.simpleGetDocuments && lastDocumentUpdatedDate != null) {
                this.storeLastDocumentUpdatedDate(esBulk, this.spaceKey, lastDocumentUpdatedDate);
            }
            this.esIntegrationComponent.executeESBulkRequest(esBulk);
            if (this.simpleGetDocuments) {
                cont = false;
                continue;
            }
            if (!lastDocumentUpdatedDate.equals(firstDocumentUpdatedDate)) {
                updatedAfter = lastDocumentUpdatedDate;
                if (res.getTotal() != null) {
                    cont = res.getTotal() > res.getStartAt() + res.getDocumentsCount();
                }
                startAt = 0;
                continue;
            }
            if (res.getTotal() != null) {
                startAt = res.getStartAt() + res.getDocumentsCount();
                cont = res.getTotal() > startAt;
                continue;
            }
            updatedAfter = new Date(lastDocumentUpdatedDate.getTime() + 1000L);
            logger.warn("All documents loaded from remote system for space '{}' contain same update timestamp {}, but we have no total count from response, so we may miss some documents because we shift timestamp for new request by one second to {}!", new Object[]{this.spaceKey, lastDocumentUpdatedDate, updatedAfter});
            startAt = 0;
        }
        if (!this.simpleGetDocuments && this.indexingInfo.documentsUpdated > 0 && lastDocumentUpdatedDate != null && updatedAfterStarting != null && updatedAfterStarting.equals(lastDocumentUpdatedDate)) {
            this.storeLastDocumentUpdatedDate(null, this.spaceKey, new Date(lastDocumentUpdatedDate.getTime() + 1000L));
        }
    }

    protected void processDelete(Date boundDate) throws Exception {
        if (boundDate == null) {
            throw new IllegalArgumentException("boundDate must be set");
        }
        this.indexingInfo.documentsDeleted = 0;
        this.indexingInfo.commentsDeleted = 0;
        if (!this.indexingInfo.fullUpdate) {
            return;
        }
        logger.debug("Go to process remote system deletes for Space {} for documents not updated in index after {}", new Object[]{this.spaceKey, boundDate});
        String indexName = this.documentIndexStructureBuilder.getDocumentSearchIndexName(this.spaceKey);
        this.esIntegrationComponent.refreshSearchIndex(indexName);
        logger.debug("go to delete indexed issues for space {} not updated after {}", new Object[]{this.spaceKey, boundDate});
        SearchRequestBuilder srb = this.esIntegrationComponent.prepareESScrollSearchRequestBuilder(indexName);
        this.documentIndexStructureBuilder.buildSearchForIndexedDocumentsNotUpdatedAfter(srb, this.spaceKey, boundDate);
        SearchResponse scrollResp = this.esIntegrationComponent.executeESSearchRequest(srb);
        if (scrollResp.getHits().getTotalHits() > 0L) {
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            scrollResp = this.esIntegrationComponent.executeESScrollSearchNextRequest(scrollResp);
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            while (scrollResp.getHits().getHits().length > 0) {
                for (SearchHit hit : scrollResp.getHits()) {
                    logger.debug("Go to delete indexed document for ES document id {}", new Object[]{hit.getId()});
                    if (this.documentIndexStructureBuilder.deleteESDocument(esBulk, hit)) {
                        ++this.indexingInfo.documentsDeleted;
                        continue;
                    }
                    ++this.indexingInfo.commentsDeleted;
                }
                if (this.isClosed()) {
                    throw new InterruptedException("Interrupted because River is closed");
                }
                scrollResp = this.esIntegrationComponent.executeESScrollSearchNextRequest(scrollResp);
            }
            this.esIntegrationComponent.executeESBulkRequest(esBulk);
        }
    }

    protected boolean isClosed() {
        return this.esIntegrationComponent != null && this.esIntegrationComponent.isClosed();
    }

    protected Date readLastDocumentUpdatedDate(String spaceKey) throws Exception {
        return this.esIntegrationComponent.readDatetimeValue(spaceKey, STORE_PROPERTYNAME_LAST_INDEXED_DOC_UPDATE_DATE);
    }

    protected void storeLastDocumentUpdatedDate(BulkRequestBuilder esBulk, String spaceKey, Date lastDocumentUpdatedDate) throws Exception {
        this.esIntegrationComponent.storeDatetimeValue(spaceKey, STORE_PROPERTYNAME_LAST_INDEXED_DOC_UPDATE_DATE, lastDocumentUpdatedDate, esBulk);
    }

    public SpaceIndexingInfo getIndexingInfo() {
        return this.indexingInfo;
    }
}

