/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jboss.elasticsearch.river.remote.DateTimeUtils;
import org.jboss.elasticsearch.river.remote.Utils;

public class SpaceIndexingInfo {
    private static final String DOCFIELD_DOCUMENTS_DELETED = "documents_deleted";
    private static final String DOCVAL_RESULT_OK = "OK";
    private static final String DOCVAL_TYPE_FULL = "FULL";
    public static final String DOCFIELD_ERROR_MESSAGE = "error_message";
    public static final String DOCFIELD_TIME_ELAPSED = "time_elapsed";
    public static final String DOCFIELD_RESULT = "result";
    public static final String DOCFIELD_DOCUMENTS_UPDATED = "documents_updated";
    public static final String DOCFIELD_UPDATE_TYPE = "update_type";
    public static final String DOCFIELD_START_DATE = "start_date";
    public static final String DOCFIELD_SPACE_KEY = "space_key";
    public String spaceKey;
    public boolean fullUpdate;
    public int documentsUpdated;
    public int documentsDeleted;
    public int commentsDeleted;
    public Date startDate;
    public boolean finishedOK;
    public long timeElapsed;
    public String errorMessage;

    public SpaceIndexingInfo(String spaceKey, boolean fullUpdate) {
        this.spaceKey = spaceKey;
        this.fullUpdate = fullUpdate;
    }

    public SpaceIndexingInfo(String spaceKey, boolean fullUpdate, int documentsUpdated, int documentsDeleted, int commentsDeleted, Date startDate, boolean finishedOK, long timeElapsed, String errorMessage) {
        this.spaceKey = spaceKey;
        this.fullUpdate = fullUpdate;
        this.documentsUpdated = documentsUpdated;
        this.documentsDeleted = documentsDeleted;
        this.commentsDeleted = commentsDeleted;
        this.startDate = startDate;
        this.finishedOK = finishedOK;
        this.timeElapsed = timeElapsed;
        this.errorMessage = errorMessage;
    }

    public XContentBuilder buildDocument(XContentBuilder builder, boolean printSpaceKey, boolean printFinalStatus) throws IOException {
        builder.startObject();
        if (printSpaceKey) {
            builder.field(DOCFIELD_SPACE_KEY, this.spaceKey);
        }
        builder.field(DOCFIELD_UPDATE_TYPE, this.fullUpdate ? DOCVAL_TYPE_FULL : "INCREMENTAL");
        builder.field(DOCFIELD_START_DATE, this.startDate);
        builder.field(DOCFIELD_DOCUMENTS_UPDATED, this.documentsUpdated);
        builder.field(DOCFIELD_DOCUMENTS_DELETED, this.documentsDeleted);
        if (printFinalStatus) {
            builder.field(DOCFIELD_RESULT, this.finishedOK ? DOCVAL_RESULT_OK : "ERROR");
            builder.field(DOCFIELD_TIME_ELAPSED, this.timeElapsed + "ms");
            if (!this.finishedOK && !Utils.isEmpty(this.errorMessage)) {
                builder.field(DOCFIELD_ERROR_MESSAGE, this.errorMessage);
            }
        }
        builder.endObject();
        return builder;
    }

    public static SpaceIndexingInfo readFromDocument(Map<String, Object> document) {
        if (document == null) {
            return null;
        }
        SpaceIndexingInfo ret = new SpaceIndexingInfo((String)document.get(DOCFIELD_SPACE_KEY), DOCVAL_TYPE_FULL.equals(document.get(DOCFIELD_UPDATE_TYPE)));
        ret.startDate = DateTimeUtils.parseISODateTime((String)document.get(DOCFIELD_START_DATE));
        ret.documentsUpdated = Utils.nodeIntegerValue(document.get(DOCFIELD_DOCUMENTS_UPDATED));
        ret.documentsDeleted = Utils.nodeIntegerValue(document.get(DOCFIELD_DOCUMENTS_DELETED));
        ret.finishedOK = DOCVAL_RESULT_OK.equals(document.get(DOCFIELD_RESULT));
        ret.timeElapsed = Long.parseLong(((String)document.get(DOCFIELD_TIME_ELAPSED)).replace("ms", ""));
        ret.errorMessage = (String)document.get(DOCFIELD_ERROR_MESSAGE);
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.spaceKey == null ? 0 : this.spaceKey.hashCode());
        return result;
    }
}

