/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class Utils {
    private static final ESLogger logger = Loggers.getLogger(Utils.class);

    public static String trimToNull(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        if ((src = src.trim()).length() == 0) {
            return null;
        }
        return src;
    }

    public static boolean isEmpty(String src) {
        return src == null || src.length() == 0 || src.trim().length() == 0;
    }

    protected static long parseTimeValue(Map<String, Object> settings, String key, long defaultDuration, TimeUnit defaultTimeUnit) {
        long ret = 0L;
        if (settings == null || !settings.containsKey(key)) {
            if (defaultTimeUnit != null) {
                ret = new TimeValue(defaultDuration, defaultTimeUnit).millis();
            }
        } else {
            try {
                ret = TimeValue.parseTimeValue((String)XContentMapValues.nodeStringValue((Object)settings.get(key), null), (TimeValue)new TimeValue(defaultDuration, defaultTimeUnit)).millis();
            }
            catch (ElasticsearchParseException e) {
                throw new ElasticsearchParseException(e.getMessage() + " for setting: " + key);
            }
        }
        return ret;
    }

    public static List<String> parseCsvString(String toParse) {
        if (toParse == null || toParse.length() == 0) {
            return null;
        }
        String[] t = toParse.split(",");
        if (t.length == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : t) {
            if (s == null || (s = s.trim()).length() <= 0) continue;
            ret.add(s);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public static String createCsvString(Collection<String> in) {
        if (in == null) {
            return null;
        }
        if (in.isEmpty()) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String s : in) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static Integer nodeIntegerValue(Object node) throws NumberFormatException {
        if (node == null) {
            return null;
        }
        if (node instanceof Integer) {
            return (Integer)node;
        }
        if (node instanceof Number) {
            return new Integer(((Number)node).intValue());
        }
        return Integer.parseInt(node.toString());
    }

    public static <T> void filterDataInMap(Map<T, Object> map, Set<T> keysToLeave) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (keysToLeave == null || keysToLeave.isEmpty()) {
            return;
        }
        HashSet<T> keysToRemove = new HashSet<T>(map.keySet());
        keysToRemove.removeAll(keysToLeave);
        if (!keysToRemove.isEmpty()) {
            for (Object rk : keysToRemove) {
                map.remove(rk);
            }
        }
    }

    public static <T> void remapDataInMap(Map<T, Object> mapToChange, Map<T, T> remapInstructions) {
        if (mapToChange == null || mapToChange.isEmpty()) {
            return;
        }
        if (remapInstructions == null || remapInstructions.isEmpty()) {
            return;
        }
        HashMap<T, Object> newMap = new HashMap<T, Object>();
        for (T keyOrig : mapToChange.keySet()) {
            if (!remapInstructions.containsKey(keyOrig)) continue;
            T keyNew = remapInstructions.get(keyOrig);
            newMap.put(keyNew, mapToChange.get(keyOrig));
        }
        mapToChange.clear();
        mapToChange.putAll(newMap);
    }

    public static Map<String, Object> loadJSONFromJarPackagedFile(String filePath) throws SettingsException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(Utils.class.getResourceAsStream(filePath));
            Map ret = parser.mapAndClose();
            if (logger.isDebugEnabled()) {
                logger.debug("jar packaged JSON file {} content is: {}", new Object[]{filePath, ret});
            }
            Map map = ret;
            return map;
        }
    }

    public static void putValueIntoMapOfMaps(Map<String, Object> map, String field, Object value) throws IllegalArgumentException {
        if (map == null) {
            return;
        }
        if (Utils.isEmpty(field)) {
            throw new IllegalArgumentException("field argument must be defined");
        }
        if (field.contains(".")) {
            String[] tokens = field.split("\\.");
            int tokensCount = tokens.length;
            LinkedHashMap<String, Object> levelData = map;
            for (String tok : tokens) {
                if (tokensCount == 1) {
                    levelData.put(tok, value);
                } else {
                    Object o = levelData.get(tok);
                    if (o == null) {
                        LinkedHashMap<String, Object> lv = new LinkedHashMap<String, Object>();
                        levelData.put(tok, lv);
                        levelData = lv;
                    } else if (o instanceof Map) {
                        levelData = (LinkedHashMap<String, Object>)o;
                    } else {
                        throw new IllegalArgumentException("Cant put value for field '" + field + "' because some element in the path is not Map");
                    }
                }
                --tokensCount;
            }
        } else {
            map.put(field, value);
        }
    }
}

