/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.remote.mgm.NodeJRMgmBaseResponse;

public abstract class JRMgmBaseResponse<T extends NodeJRMgmBaseResponse>
extends NodesOperationResponse<T> {
    public JRMgmBaseResponse() {
    }

    public JRMgmBaseResponse(ClusterName clusterName, T[] nodes) {
        super(clusterName, nodes);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = this.newNodeResponsesArray(in.readVInt());
        for (int i = 0; i < ((NodeJRMgmBaseResponse[])this.nodes).length; ++i) {
            T node = this.newNodeResponse();
            ((NodeJRMgmBaseResponse)((Object)node)).readFrom(in);
            ((NodeJRMgmBaseResponse[])this.nodes)[i] = node;
        }
    }

    protected abstract T[] newNodeResponsesArray(int var1);

    protected abstract T newNodeResponse();

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeJRMgmBaseResponse[])this.nodes).length);
        for (NodeJRMgmBaseResponse node : (NodeJRMgmBaseResponse[])this.nodes) {
            node.writeTo(out);
        }
    }

    public T getSuccessNodeResponse() {
        if (this.nodes == null || ((NodeJRMgmBaseResponse[])this.nodes).length == 0) {
            return null;
        }
        for (NodeJRMgmBaseResponse resp : (NodeJRMgmBaseResponse[])this.nodes) {
            if (!resp.riverFound) continue;
            return (T)((Object)resp);
        }
        return null;
    }
}

