/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.sitemap;

import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.jboss.elasticsearch.river.remote.sitemap.AbstractSiteMap;

public class SiteMapIndex
extends AbstractSiteMap {
    private Hashtable<String, AbstractSiteMap> sitemaps = new Hashtable();

    public SiteMapIndex() {
    }

    public SiteMapIndex(URL url) {
        this();
        this.url = url;
    }

    public Collection<AbstractSiteMap> getSitemaps() {
        return this.sitemaps.values();
    }

    void addSitemap(AbstractSiteMap sitemap) {
        this.sitemaps.put(sitemap.getUrl().toString(), sitemap);
    }

    public AbstractSiteMap getSitemap(URL url) {
        return this.sitemaps.get(url.toString());
    }

    public boolean hasUnprocessedSitemap() {
        for (Map.Entry<String, AbstractSiteMap> sitemap : this.sitemaps.entrySet()) {
            AbstractSiteMap s = sitemap.getValue();
            if (s.isProcessed()) continue;
            return true;
        }
        return false;
    }

    public AbstractSiteMap nextUnprocessedSitemap() {
        for (Map.Entry<String, AbstractSiteMap> sitemap : this.sitemaps.entrySet()) {
            AbstractSiteMap s = sitemap.getValue();
            if (s.isProcessed()) continue;
            return s;
        }
        return null;
    }

    public String toString() {
        return "url=\"" + this.url + "\",sitemapListSize=" + this.sitemaps.size();
    }

    @Override
    public boolean isIndex() {
        return true;
    }
}

