/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.common.logging.Loggers;
import org.jboss.elasticsearch.river.remote.ChangedDocumentsResults;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.SpaceIndexerBase;
import org.jboss.elasticsearch.river.remote.SpaceIndexingInfo;

public class SpaceSimpleIndexer
extends SpaceIndexerBase {
    private static final int MAX_BULK_SIZE_IN_SIMPLE_GET = 50;
    protected int bulkSize = 50;

    public SpaceSimpleIndexer(String spaceKey, IRemoteSystemClient remoteSystemClient, IESIntegration esIntegrationComponent, IDocumentIndexStructureBuilder documentIndexStructureBuilder) {
        super(spaceKey, remoteSystemClient, esIntegrationComponent, documentIndexStructureBuilder);
        this.logger = Loggers.getLogger(SpaceSimpleIndexer.class);
        this.indexingInfo = new SpaceIndexingInfo(spaceKey, true);
    }

    @Override
    protected void processUpdate() throws Exception {
        this.indexingInfo.documentsUpdated = 0;
        this.logger.info("Go to perform full simple update for Space {}", new Object[]{this.spaceKey});
        ChangedDocumentsResults res = this.remoteSystemClient.getChangedDocuments(this.spaceKey, 0, null);
        if (res.getDocuments() != null && !res.getDocuments().isEmpty()) {
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            int updatedInThisBulk = 0;
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            for (Map<String, Object> document : res.getDocuments()) {
                String documentId = this.getDocumentIdChecked(document);
                if (this.getDocumentDetail(documentId, document)) {
                    this.documentIndexStructureBuilder.indexDocument(esBulk, this.spaceKey, document);
                    if (++updatedInThisBulk >= this.bulkSize) {
                        this.executeBulkUpdate(esBulk);
                        this.indexingInfo.documentsUpdated += updatedInThisBulk;
                        esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
                        updatedInThisBulk = 0;
                    }
                }
                if (!this.isClosed()) continue;
                throw new InterruptedException("Interrupted because River is closed");
            }
            if (updatedInThisBulk > 0) {
                this.executeBulkUpdate(esBulk);
                this.indexingInfo.documentsUpdated += updatedInThisBulk;
            }
        }
    }
}

