/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.river.remote.BulkUpdatePartialFailureException;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.SpaceIndexingInfo;
import org.jboss.elasticsearch.river.remote.Utils;
import org.jboss.elasticsearch.river.remote.exception.RemoteDocumentNotFoundException;

public abstract class SpaceIndexerBase
implements Runnable {
    public static final String KEY_DETAIL = "detail";
    protected ESLogger logger;
    protected final IRemoteSystemClient remoteSystemClient;
    protected final IESIntegration esIntegrationComponent;
    protected final IDocumentIndexStructureBuilder documentIndexStructureBuilder;
    protected final String spaceKey;
    protected long startTime = 0L;
    protected SpaceIndexingInfo indexingInfo;

    public SpaceIndexerBase(String spaceKey, IRemoteSystemClient remoteSystemClient, IESIntegration esIntegrationComponent, IDocumentIndexStructureBuilder documentIndexStructureBuilder) {
        if (Utils.isEmpty(spaceKey)) {
            throw new IllegalArgumentException("spaceKey must be defined");
        }
        this.remoteSystemClient = remoteSystemClient;
        this.spaceKey = spaceKey;
        this.esIntegrationComponent = esIntegrationComponent;
        this.documentIndexStructureBuilder = documentIndexStructureBuilder;
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.indexingInfo.startDate = new Date(this.startTime);
        try {
            this.processUpdate();
            this.processDelete(new Date(this.startTime));
            this.indexingInfo.timeElapsed = System.currentTimeMillis() - this.startTime;
            this.indexingInfo.finishedOK = true;
            this.esIntegrationComponent.reportIndexingFinished(this.indexingInfo);
            this.logger.info("Finished {} update for Space {}. {} updated and {} deleted documents. Time elapsed {}s.", new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.spaceKey, this.indexingInfo.documentsUpdated, this.indexingInfo.documentsDeleted, this.indexingInfo.timeElapsed / 1000L});
            if (this.indexingInfo.getErrorMessage() != null) {
                this.logger.info("Update for Space {} contained {} documents with skipped unfatal errors: " + this.indexingInfo.getErrorMessage(), new Object[]{this.spaceKey, this.indexingInfo.documentsWithError});
            }
        }
        catch (Throwable e) {
            this.indexingInfo.timeElapsed = System.currentTimeMillis() - this.startTime;
            this.indexingInfo.addErrorMessage(e.getMessage());
            this.indexingInfo.finishedOK = false;
            this.esIntegrationComponent.reportIndexingFinished(this.indexingInfo);
            Throwable cause = e;
            if ((cause instanceof IOException || cause instanceof InterruptedException) && cause.getMessage() != null) {
                cause = null;
            }
            this.logger.error("Failed {} update for Space {} due: {}", cause, new Object[]{this.indexingInfo.fullUpdate ? "full" : "incremental", this.spaceKey, e.getMessage()});
        }
    }

    protected abstract void processUpdate() throws Exception;

    protected boolean getDocumentDetail(String documentId, Map<String, Object> document) throws Exception {
        try {
            Object detail = this.remoteSystemClient.getChangedDocumentDetails(this.spaceKey, documentId, document);
            if (detail != null) {
                document.put(KEY_DETAIL, detail);
            }
            return true;
        }
        catch (RemoteDocumentNotFoundException e) {
            String msg = "Detail processing problem for document with id ' documentId', so we skip it: " + e.getMessage();
            this.indexingInfo.addErrorMessage(msg);
            ++this.indexingInfo.documentsWithError;
            this.logger.warn(msg, new Object[0]);
            return false;
        }
    }

    protected String getDocumentIdChecked(Map<String, Object> document) {
        String documentId = this.documentIndexStructureBuilder.extractDocumentId(document);
        if (Utils.isEmpty(documentId)) {
            throw new IllegalArgumentException("Document ID not found in remote system response for Space " + this.spaceKey + " within data: " + document);
        }
        return documentId;
    }

    protected void executeBulkUpdate(BulkRequestBuilder esBulk) {
        try {
            this.esIntegrationComponent.executeESBulkRequest(esBulk);
        }
        catch (BulkUpdatePartialFailureException e) {
            this.indexingInfo.addErrorMessage(e.getMessage());
            this.indexingInfo.documentsWithError += e.getNumOfFailures();
            this.indexingInfo.documentsUpdated -= e.getNumOfFailures();
        }
    }

    protected void processDelete(Date boundDate) throws Exception {
        if (boundDate == null) {
            throw new IllegalArgumentException("boundDate must be set");
        }
        this.indexingInfo.documentsDeleted = 0;
        this.indexingInfo.commentsDeleted = 0;
        if (!this.indexingInfo.fullUpdate) {
            return;
        }
        this.logger.debug("Go to process remote system deletes for Space {} for documents not updated in index after {}", new Object[]{this.spaceKey, boundDate});
        String indexName = this.documentIndexStructureBuilder.getDocumentSearchIndexName(this.spaceKey);
        this.esIntegrationComponent.refreshSearchIndex(indexName);
        this.logger.debug("go to delete indexed issues for space {} not updated after {}", new Object[]{this.spaceKey, boundDate});
        SearchRequestBuilder srb = this.esIntegrationComponent.prepareESScrollSearchRequestBuilder(indexName);
        this.documentIndexStructureBuilder.buildSearchForIndexedDocumentsNotUpdatedAfter(srb, this.spaceKey, boundDate);
        SearchResponse scrollResp = this.esIntegrationComponent.executeESSearchRequest(srb);
        if (scrollResp.getHits().getTotalHits() > 0L) {
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            scrollResp = this.esIntegrationComponent.executeESScrollSearchNextRequest(scrollResp);
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            while (scrollResp.getHits().getHits().length > 0) {
                for (SearchHit hit : scrollResp.getHits()) {
                    this.logger.debug("Go to delete indexed document for ES document id {}", new Object[]{hit.getId()});
                    if (this.documentIndexStructureBuilder.deleteESDocument(esBulk, hit)) {
                        ++this.indexingInfo.documentsDeleted;
                        continue;
                    }
                    ++this.indexingInfo.commentsDeleted;
                }
                if (this.isClosed()) {
                    throw new InterruptedException("Interrupted because River is closed");
                }
                scrollResp = this.esIntegrationComponent.executeESScrollSearchNextRequest(scrollResp);
            }
            this.esIntegrationComponent.executeESBulkRequest(esBulk);
        }
    }

    protected boolean isClosed() {
        return this.esIntegrationComponent != null && this.esIntegrationComponent.isClosed();
    }

    public SpaceIndexingInfo getIndexingInfo() {
        return this.indexingInfo;
    }
}

