/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.river.remote.ChangedDocumentsResults;
import org.jboss.elasticsearch.river.remote.HttpRemoteSystemClientBase;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.IPwdLoader;
import org.jboss.elasticsearch.river.remote.Utils;
import org.jboss.elasticsearch.river.remote.exception.RemoteDocumentNotFoundException;

public class GetJSONClient
extends HttpRemoteSystemClientBase {
    protected static final String CFG_GET_DOCS_RES_FIELD_TOTALCOUNT = "getDocsResFieldTotalcount";
    protected static final String CFG_GET_DOCS_RES_FIELD_DOCUMENTS = "getDocsResFieldDocuments";
    protected static final String CFG_GET_SPACES_RESPONSE_FIELD = "getSpacesResField";
    protected static final String CFG_URL_GET_SPACES = "urlGetSpaces";
    protected static final String CFG_URL_GET_DOCUMENTS = "urlGetDocuments";
    protected static final String CFG_URL_GET_DOCUMENT_DETAILS = "urlGetDocumentDetails";
    protected static final String CFG_URL_GET_DOCUMENT_DETAILS_FIELD = "urlGetDocumentDetailsField";
    protected static final String CFG_HEADER_ACCEPT = "headerAccept";
    private ESLogger logger = Loggers.getLogger(GetJSONClient.class);
    protected String urlGetSpaces;
    protected String getSpacesResField;
    protected String getDocsResFieldDocuments;
    protected String getDocsResFieldTotalcount;
    protected String urlGetDocuments;
    protected String urlGetDocumentDetails;
    protected String urlGetDocumentDetailsField;
    protected static final String HEADER_ACCEPT_DEFAULT = "application/json";
    protected Map<String, String> headers = new HashMap<String, String>();

    @Override
    public void init(IESIntegration esIntegration, Map<String, Object> config, boolean spaceListLoadingEnabled, IPwdLoader pwdLoader) {
        this.logger = esIntegration.createLogger(GetJSONClient.class);
        this.urlGetDocuments = GetJSONClient.getUrlFromConfig(config, CFG_URL_GET_DOCUMENTS, true);
        this.urlGetDocumentDetails = GetJSONClient.getUrlFromConfig(config, CFG_URL_GET_DOCUMENT_DETAILS, false);
        this.urlGetDocumentDetailsField = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_URL_GET_DOCUMENT_DETAILS_FIELD), null));
        if (this.urlGetDocumentDetails != null && this.urlGetDocumentDetailsField != null) {
            throw new SettingsException("You can use only one of remote/urlGetDocumentDetails and remote/urlGetDocumentDetailsField configuration parametr.");
        }
        this.getDocsResFieldDocuments = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_GET_DOCS_RES_FIELD_DOCUMENTS), null));
        this.getDocsResFieldTotalcount = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_GET_DOCS_RES_FIELD_TOTALCOUNT), null));
        String headerAccept = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_HEADER_ACCEPT), (String)HEADER_ACCEPT_DEFAULT));
        if (headerAccept == null) {
            headerAccept = HEADER_ACCEPT_DEFAULT;
        }
        this.headers.put("Accept", headerAccept);
        if (spaceListLoadingEnabled) {
            this.urlGetSpaces = GetJSONClient.getUrlFromConfig(config, CFG_URL_GET_SPACES, true);
            this.getSpacesResField = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_GET_SPACES_RESPONSE_FIELD), null));
        }
        String remoteUsername = this.initHttpClient(this.logger, config, pwdLoader, this.urlGetDocuments);
        this.logger.info("Configured GET JSON remote client. Spaces listing URL '{}', documents listing url '{}', document detail url '{}', document detail url field '{}', remote system user '{}'.", new Object[]{this.urlGetSpaces != null ? this.urlGetSpaces : "unused", this.urlGetDocuments, this.urlGetDocumentDetails != null ? this.urlGetDocumentDetails : "", this.urlGetDocumentDetailsField != null ? this.urlGetDocumentDetailsField : "", remoteUsername != null ? remoteUsername : "Anonymous access"});
    }

    @Override
    public List<String> getAllSpaces() throws Exception {
        ArrayList<String> ret;
        block9: {
            byte[] responseData = this.performHttpGetCall((String)this.urlGetSpaces, this.headers).content;
            this.logger.debug("Get Spaces REST response data: {}", new Object[]{new String(responseData)});
            Object responseParsed = this.parseJSONResponse(responseData);
            ret = new ArrayList<String>();
            if (this.getSpacesResField != null) {
                if (responseParsed instanceof Map) {
                    responseParsed = XContentMapValues.extractValue((String)this.getSpacesResField, (Map)((Map)responseParsed));
                } else {
                    throw new Exception("Get Spaces REST response structure is unsupported (we need a Map to take configured getSpacesResponseField from it) " + responseParsed);
                }
            }
            try {
                if (responseParsed instanceof List) {
                    List l = (List)responseParsed;
                    for (Object s : l) {
                        ret.add(s.toString());
                    }
                    break block9;
                }
                if (responseParsed instanceof Map) {
                    Map l = (Map)responseParsed;
                    for (String s : l.keySet()) {
                        ret.add(s);
                    }
                    break block9;
                }
                throw new Exception("Get Spaces REST response structure is unsupported " + responseParsed);
            }
            catch (ClassCastException e) {
                throw new Exception("Get Spaces REST response structure is unsupported " + responseParsed);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object parseJSONResponse(byte[] responseData) throws UnsupportedEncodingException, IOException {
        try (XContentParser parser = null;){
            StringBuilder sb = new StringBuilder();
            sb.append("{ \"wrapit\" : ").append(new String(responseData, "UTF-8")).append("}");
            responseData = sb.toString().getBytes("UTF-8");
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(responseData);
            Map wrappedResponseParsed = parser.mapAndClose();
            Object v = wrappedResponseParsed.get("wrapit");
            return v;
        }
    }

    @Override
    public Object getChangedDocumentDetails(String spaceKey, String documentId, Map<String, Object> document) throws Exception, RemoteDocumentNotFoundException {
        try {
            String url = null;
            if (this.urlGetDocumentDetailsField != null) {
                if (document != null) {
                    try {
                        url = Utils.trimToNull((String)XContentMapValues.extractValue((String)this.urlGetDocumentDetailsField, document));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (url == null) {
                    this.logger.warn("Document detail URL not found in field '{}' for space '" + spaceKey + "' and document id=" + documentId, new Object[]{this.urlGetDocumentDetailsField});
                } else {
                    try {
                        new URL(url);
                    }
                    catch (MalformedURLException e) {
                        this.logger.warn("Invalid document detail URL '{}' obtained from field '{}' for space '" + spaceKey + "' and document id=" + documentId, new Object[]{url, this.urlGetDocumentDetailsField});
                        url = null;
                    }
                }
            } else if (this.urlGetDocumentDetails != null) {
                url = GetJSONClient.enhanceUrlGetDocumentDetails(this.urlGetDocumentDetails, spaceKey, documentId);
            }
            if (url == null) {
                return null;
            }
            byte[] responseData = this.performHttpGetCall((String)url, this.headers).content;
            return this.parseJSONResponse(responseData);
        }
        catch (HttpRemoteSystemClientBase.HttpCallException e) {
            if (e.getStatusCode() == 404) {
                throw new RemoteDocumentNotFoundException(e);
            }
            throw e;
        }
    }

    protected static String enhanceUrlGetDocumentDetails(String url, String spaceKey, String documentId) throws UnsupportedEncodingException {
        url = url.replaceAll("\\{space\\}", URLEncoder.encode(spaceKey, "UTF-8"));
        url = url.replaceAll("\\{id\\}", URLEncoder.encode(documentId, "UTF-8"));
        return url;
    }

    @Override
    public ChangedDocumentsResults getChangedDocuments(String spaceKey, int startAt, Date updatedAfter) throws Exception {
        String url = GetJSONClient.enhanceUrlGetDocuments(this.urlGetDocuments, spaceKey, updatedAfter, startAt);
        byte[] responseData = this.performHttpGetCall((String)url, this.headers).content;
        this.logger.debug("Get Documents REST response data: {}", new Object[]{new String(responseData)});
        try {
            Object responseParsed = this.parseJSONResponse(responseData);
            Integer total = null;
            if (this.getDocsResFieldTotalcount != null) {
                Object totalObj = XContentMapValues.extractValue((String)this.getDocsResFieldTotalcount, (Map)((Map)responseParsed));
                if (totalObj != null) {
                    if (totalObj instanceof Integer) {
                        total = (Integer)totalObj;
                    } else {
                        try {
                            total = Integer.parseInt(totalObj.toString());
                        }
                        catch (NumberFormatException e) {
                            throw new Exception("Value from configured getDocsResFieldTotalcount field is not convertable to number: " + totalObj);
                        }
                    }
                } else {
                    throw new Exception("Configured getDocsResFieldTotalcount field has no value");
                }
            }
            List documents = null;
            documents = this.getDocsResFieldDocuments != null ? (List)XContentMapValues.extractValue((String)this.getDocsResFieldDocuments, (Map)((Map)responseParsed)) : (List)responseParsed;
            return new ChangedDocumentsResults(documents, startAt, total);
        }
        catch (ClassCastException e) {
            throw new Exception("Get Documents REST response structure is invalid " + responseData);
        }
    }

    protected static String enhanceUrlGetDocuments(String url, String spaceKey, Date updatedAfter, int startAt) throws UnsupportedEncodingException {
        url = url.replaceAll("\\{space\\}", URLEncoder.encode(spaceKey, "UTF-8"));
        url = url.replaceAll("\\{updatedAfter\\}", updatedAfter != null ? updatedAfter.getTime() + "" : "");
        url = url.replaceAll("\\{startAtIndex\\}", startAt + "");
        return url;
    }

    @Override
    public void setIndexStructureBuilder(IDocumentIndexStructureBuilder indexStructureBuilder) {
        this.indexStructureBuilder = indexStructureBuilder;
    }

    @Override
    public IDocumentIndexStructureBuilder getIndexStructureBuilder() {
        return this.indexStructureBuilder;
    }
}

