/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.incrementalupdate;

import java.io.IOException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.remote.mgm.NodeJRMgmBaseResponse;

public class NodeIncrementalUpdateResponse
extends NodeJRMgmBaseResponse {
    protected boolean spaceFound;
    protected String reindexedSpaces;

    protected NodeIncrementalUpdateResponse() {
    }

    public NodeIncrementalUpdateResponse(DiscoveryNode node) {
        super(node);
    }

    public NodeIncrementalUpdateResponse(DiscoveryNode node, boolean riverFound, boolean spaceFound, String reindexedSpaces) {
        super(node, riverFound);
        this.spaceFound = spaceFound;
        this.reindexedSpaces = reindexedSpaces;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.spaceFound = in.readBoolean();
        this.reindexedSpaces = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.spaceFound);
        out.writeOptionalString(this.reindexedSpaces);
    }

    public boolean isSpaceFound() {
        return this.spaceFound;
    }

    public String getReindexedSpaces() {
        return this.reindexedSpaces;
    }
}

