/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessor;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class StructuredContentPreprocessorFactory {
    public static final String CFG_SETTINGS = "settings";
    public static final String CFG_CLASS = "class";
    public static final String CFG_NAME = "name";

    public static StructuredContentPreprocessor createPreprocessor(Map<String, Object> preprocessorConfig, Client client) throws IllegalArgumentException {
        String name = StructureUtils.getStringValue(preprocessorConfig, CFG_NAME);
        if (ValueUtils.isEmpty(name)) {
            throw new IllegalArgumentException("'name' element not defined");
        }
        String className = StructureUtils.getStringValue(preprocessorConfig, CFG_CLASS);
        if (ValueUtils.isEmpty(className)) {
            throw new IllegalArgumentException("'class' element not defined for preprocessor " + name);
        }
        Object settings = preprocessorConfig.get(CFG_SETTINGS);
        if (settings != null && !(settings instanceof Map)) {
            throw new IllegalArgumentException("'settings' element must be Map for preprocessor " + name);
        }
        try {
            StructuredContentPreprocessor preproc = (StructuredContentPreprocessor)Class.forName(className).newInstance();
            preproc.init(name, client, (Map)settings);
            return preproc;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Preprocessor class " + className + " creation exception " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Preprocessor class " + className + " creation exception " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Preprocessor class " + className + " not found", e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Preprocessor class " + className + " must implement interface " + StructuredContentPreprocessor.class.getName());
        }
    }

    public static List<StructuredContentPreprocessor> createPreprocessors(List<Map<String, Object>> preprocessorConfig, Client client) throws IllegalArgumentException {
        ArrayList<StructuredContentPreprocessor> ret = new ArrayList<StructuredContentPreprocessor>();
        if (preprocessorConfig != null) {
            for (Map<String, Object> cfgMap : preprocessorConfig) {
                ret.add(StructuredContentPreprocessorFactory.createPreprocessor(cfgMap, client));
            }
        }
        return ret;
    }
}

