/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.river.remote.Utils;

public enum SpaceIndexingMode {
    SIMPLE("simple", false, false),
    PAGINATION("pagination", false, false),
    UPDATE_TIMESTAMP("updateTimestamp", true, true);

    private String configValue;
    private boolean incrementalUpdateSupported;
    private boolean updateDateMandatory;

    private SpaceIndexingMode(String configValue, boolean updateDateMandatory, boolean incrementalUpdateSupported) {
        this.configValue = configValue;
        this.updateDateMandatory = updateDateMandatory;
        this.incrementalUpdateSupported = incrementalUpdateSupported;
    }

    public String getConfigValue() {
        return this.configValue;
    }

    public boolean isUpdateDateMandatory() {
        return this.updateDateMandatory;
    }

    public boolean isIncrementalUpdateSupported() {
        return this.incrementalUpdateSupported;
    }

    public static SpaceIndexingMode parseConfiguration(String value) {
        if ((value = Utils.trimToNull(value)) == null) {
            return null;
        }
        if (SIMPLE.getConfigValue().equalsIgnoreCase(value)) {
            return SIMPLE;
        }
        if (PAGINATION.getConfigValue().equalsIgnoreCase(value)) {
            return PAGINATION;
        }
        if (UPDATE_TIMESTAMP.getConfigValue().equalsIgnoreCase(value)) {
            return UPDATE_TIMESTAMP;
        }
        throw new SettingsException("unsupported value for space indexing mode: " + value);
    }
}

