/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.river.remote.CommentIndexingMode;
import org.jboss.elasticsearch.river.remote.DateTimeUtils;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.Utils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessor;

public class DocumentWithCommentsIndexStructureBuilder
implements IDocumentIndexStructureBuilder {
    private ESLogger logger = Loggers.getLogger(DocumentWithCommentsIndexStructureBuilder.class);
    protected String riverName;
    protected String indexName;
    protected String issueTypeName;
    protected static final String CONFIG_FIELDS = "fields";
    protected static final String CONFIG_FIELDS_REMOTEFIELD = "remote_field";
    protected static final String CONFIG_FIELDS_VALUEFILTER = "value_filter";
    protected static final String CONFIG_FILTERS = "value_filters";
    protected static final String CONFIG_REMOTEFIELD_DOCUMENTID = "remote_field_document_id";
    protected static final String CONFIG_REMOTEFIELD_UPDATED = "remote_field_updated";
    protected static final String CONFIG_REMOTEFIELD_UPDATED_FORMAT = "remote_field_updated_format";
    protected static final String CONFIG_REMOTEFIELD_DELETED = "remote_field_deleted";
    protected static final String CONFIG_REMOTEFIELD_DELETEDVALUE = "remote_field_deleted_value";
    protected static final String CONFIG_REMOTEFIELD_COMMENTS = "remote_field_comments";
    protected static final String CONFIG_REMOTEFIELD_COMMENTID = "remote_field_comment_id";
    protected static final String CONFIG_FIELDRIVERNAME = "field_river_name";
    protected static final String CONFIG_FIELDSPACEKEY = "field_space_key";
    protected static final String CONFIG_FIELDDOCUMENTID = "field_document_id";
    protected static final String CONFIG_COMMENTMODE = "comment_mode";
    protected static final String CONFIG_FIELDCOMMENTS = "field_comments";
    protected static final String CONFIG_COMMENTTYPE = "comment_type";
    protected static final String CONFIG_COMMENTFILEDS = "comment_fields";
    protected String remoteDataFieldForDocumentId = null;
    protected String remoteDataFieldForUpdated = null;
    protected String remoteDataFieldForUpdatedFormat = null;
    protected String remoteDataFieldForDeleted;
    protected String remoteDataValueForDeleted;
    protected String remoteDataFieldForComments = null;
    protected String remoteDataFieldForCommentId = null;
    protected Map<String, Map<String, String>> fieldsConfig;
    protected Map<String, Map<String, String>> filtersConfig;
    protected String indexFieldForRiverName = null;
    protected String indexFieldForSpaceKey = null;
    protected String indexFieldForRemoteDocumentId = null;
    protected CommentIndexingMode commentIndexingMode;
    protected String indexFieldForComments = null;
    protected String commentTypeName;
    protected Map<String, Map<String, String>> commentFieldsConfig;
    protected List<StructuredContentPreprocessor> issueDataPreprocessors = null;

    protected DocumentWithCommentsIndexStructureBuilder() {
    }

    public DocumentWithCommentsIndexStructureBuilder(IESIntegration esIntegrationComponent, String indexName, String issueTypeName, Map<String, Object> settings, boolean dateOfUpdateFieldMandatory) throws SettingsException {
        this.logger = esIntegrationComponent.createLogger(DocumentWithCommentsIndexStructureBuilder.class);
        this.riverName = esIntegrationComponent.riverName().getName();
        this.indexName = indexName;
        this.issueTypeName = issueTypeName;
        if (settings != null) {
            this.remoteDataFieldForDocumentId = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_DOCUMENTID), null));
            this.remoteDataFieldForUpdated = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_UPDATED), null));
            this.remoteDataFieldForUpdatedFormat = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_UPDATED_FORMAT), null));
            this.remoteDataFieldForComments = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_COMMENTS), null));
            this.remoteDataFieldForCommentId = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_COMMENTID), null));
            this.remoteDataFieldForDeleted = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_DELETED), null));
            this.remoteDataValueForDeleted = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_REMOTEFIELD_DELETEDVALUE), null));
            this.indexFieldForRiverName = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDRIVERNAME), null);
            this.indexFieldForSpaceKey = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDSPACEKEY), null);
            this.indexFieldForRemoteDocumentId = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDDOCUMENTID), null);
            this.filtersConfig = (Map)settings.get(CONFIG_FILTERS);
            this.fieldsConfig = (Map)settings.get(CONFIG_FIELDS);
            this.commentIndexingMode = CommentIndexingMode.parseConfiguration(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_COMMENTMODE), null));
            this.indexFieldForComments = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDCOMMENTS), null);
            this.commentTypeName = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_COMMENTTYPE), null);
            this.commentFieldsConfig = (Map)settings.get(CONFIG_COMMENTFILEDS);
        }
        this.loadDefaultsIfNecessary();
        this.validateConfiguration(dateOfUpdateFieldMandatory);
    }

    private void loadDefaultsIfNecessary() {
        Map<String, Object> settingsDefault = this.loadDefaultSettingsMapFromFile();
        this.indexFieldForRiverName = this.loadDefaultStringIfNecessary(this.indexFieldForRiverName, CONFIG_FIELDRIVERNAME, settingsDefault);
        this.indexFieldForSpaceKey = this.loadDefaultStringIfNecessary(this.indexFieldForSpaceKey, CONFIG_FIELDSPACEKEY, settingsDefault);
        this.indexFieldForRemoteDocumentId = this.loadDefaultStringIfNecessary(this.indexFieldForRemoteDocumentId, CONFIG_FIELDDOCUMENTID, settingsDefault);
        if (this.filtersConfig == null) {
            this.filtersConfig = new HashMap<String, Map<String, String>>();
        }
        if (this.commentIndexingMode == null) {
            this.commentIndexingMode = CommentIndexingMode.parseConfiguration(XContentMapValues.nodeStringValue((Object)settingsDefault.get(CONFIG_COMMENTMODE), null));
        }
    }

    private void validateConfiguration(boolean dateOfUpdateMandatory) {
        this.validateConfigurationString(this.remoteDataFieldForDocumentId, "index/remote_field_document_id");
        if (dateOfUpdateMandatory) {
            this.validateConfigurationString(this.remoteDataFieldForUpdated, "index/remote_field_updated");
        }
        if (this.remoteDataFieldForDeleted == null && this.remoteDataValueForDeleted != null || this.remoteDataFieldForDeleted != null && this.remoteDataValueForDeleted == null) {
            throw new SettingsException("Configuration fields 'index/remote_field_deleted' and 'index/remote_field_deleted_value' must be both set or both empty");
        }
        this.validateConfigurationObject(this.filtersConfig, "index/value_filters");
        this.validateConfigurationObject(this.fieldsConfig, "index/fields");
        this.validateConfigurationString(this.indexFieldForRiverName, "index/field_river_name");
        this.validateConfigurationString(this.indexFieldForSpaceKey, "index/field_space_key");
        this.validateConfigurationString(this.indexFieldForRemoteDocumentId, "index/field_document_id");
        this.validateConfigurationObject((Object)this.commentIndexingMode, "index/comment_mode");
        if (this.commentIndexingMode != CommentIndexingMode.NONE) {
            this.validateConfigurationString(this.remoteDataFieldForComments, "index/remote_field_comments");
            this.validateConfigurationString(this.indexFieldForComments, "index/field_comments");
            this.validateConfigurationObject(this.commentFieldsConfig, "index/comment_fields");
            this.validateConfigurationFieldsStructure(this.commentFieldsConfig, "index/comment_fields");
            if (this.commentIndexingMode.isExtraDocumentIndexed()) {
                this.validateConfigurationString(this.commentTypeName, "index/comment_type");
                this.validateConfigurationString(this.remoteDataFieldForCommentId, "index/remote_field_comment_id");
            }
        }
        this.validateConfigurationFieldsStructure(this.fieldsConfig, "index/fields");
    }

    @Override
    public void addDataPreprocessor(StructuredContentPreprocessor preprocessor) {
        if (preprocessor == null) {
            return;
        }
        if (this.issueDataPreprocessors == null) {
            this.issueDataPreprocessors = new ArrayList<StructuredContentPreprocessor>();
        }
        this.issueDataPreprocessors.add(preprocessor);
    }

    @Override
    public String getDocumentSearchIndexName(String spaceKey) {
        return this.indexName;
    }

    @Override
    public void indexDocument(BulkRequestBuilder esBulk, String spaceKey, Map<String, Object> document) throws Exception {
        List<Map<String, Object>> comments;
        document.put("spaceKey", spaceKey);
        document = this.preprocessDocumentData(spaceKey, document);
        esBulk.add(Requests.indexRequest((String)this.indexName).type(this.issueTypeName).id(this.extractDocumentId(document)).source(this.prepareIndexedDocument(spaceKey, document)));
        if (this.commentIndexingMode.isExtraDocumentIndexed() && (comments = this.extractComments(document)) != null && !comments.isEmpty()) {
            String issueKey = this.extractDocumentId(document);
            for (Map<String, Object> comment : comments) {
                String commentId = this.extractCommentId(comment);
                IndexRequest irq = Requests.indexRequest((String)this.indexName).type(this.commentTypeName).id(commentId).source(this.prepareCommentIndexedDocument(spaceKey, issueKey, comment));
                if (this.commentIndexingMode == CommentIndexingMode.CHILD) {
                    irq.parent(issueKey);
                }
                esBulk.add(irq);
            }
        }
    }

    @Override
    public String extractDocumentId(Map<String, Object> document) {
        return this.extractIdValueFromDocumentField(document, this.remoteDataFieldForDocumentId, CONFIG_REMOTEFIELD_DOCUMENTID);
    }

    private String extractIdValueFromDocumentField(Map<String, Object> document, String idFieldName, String idFieldConfigPropertyName) {
        Object id = XContentMapValues.extractValue((String)idFieldName, document);
        if (id == null) {
            return null;
        }
        if (!Utils.isSimpleValue(id)) {
            throw new SettingsException("Remote data field '" + idFieldName + "' defined in 'index/" + idFieldConfigPropertyName + "' config param must provide simple value, but value is " + id);
        }
        return id.toString();
    }

    @Override
    public Date extractDocumentUpdated(Map<String, Object> document) {
        Object val = XContentMapValues.extractValue((String)this.remoteDataFieldForUpdated, document);
        if (val == null) {
            return null;
        }
        if (!Utils.isSimpleValue(val)) {
            throw new SettingsException("Remote data field '" + this.remoteDataFieldForUpdated + "' must provide simple value, but value is " + val);
        }
        if (val instanceof Date) {
            return (Date)val;
        }
        try {
            return DateTimeUtils.parseDate(val.toString(), this.remoteDataFieldForUpdatedFormat);
        }
        catch (IllegalArgumentException e1) {
            throw new SettingsException("Remote data field '" + this.remoteDataFieldForUpdated + "' is not reecognized: " + val);
        }
    }

    @Override
    public boolean extractDocumentDeleted(Map<String, Object> document) {
        if (document == null || this.remoteDataFieldForDeleted == null) {
            return false;
        }
        Object val = XContentMapValues.extractValue((String)this.remoteDataFieldForDeleted, document);
        if (val == null) {
            return false;
        }
        if (!Utils.isSimpleValue(val)) {
            throw new SettingsException("Remote data field '" + this.remoteDataFieldForDeleted + "' must provide simple value, but value is " + val);
        }
        String v = null;
        v = val instanceof String ? (String)val : val.toString();
        return v.equals(this.remoteDataValueForDeleted);
    }

    protected String extractCommentId(Map<String, Object> comment) {
        String commentId = this.extractIdValueFromDocumentField(comment, this.remoteDataFieldForCommentId, CONFIG_REMOTEFIELD_COMMENTID);
        if (commentId == null) {
            throw new IllegalArgumentException("Comment ID not found in remote system response within data: " + comment);
        }
        return commentId;
    }

    protected Map<String, Object> preprocessDocumentData(String spaceKey, Map<String, Object> document) {
        if (this.issueDataPreprocessors != null) {
            for (StructuredContentPreprocessor prepr : this.issueDataPreprocessors) {
                document = prepr.preprocessData(document);
            }
        }
        return document;
    }

    @Override
    public void buildSearchForIndexedDocumentsNotUpdatedAfter(SearchRequestBuilder srb, String spaceKey, Date date) {
        RangeFilterBuilder filterTime = FilterBuilders.rangeFilter((String)"_timestamp").lt((Object)date);
        TermFilterBuilder filterSpaceKey = FilterBuilders.termFilter((String)this.indexFieldForSpaceKey, (String)spaceKey);
        TermFilterBuilder filterSource = FilterBuilders.termFilter((String)this.indexFieldForRiverName, (String)this.riverName);
        BoolFilterBuilder filter = FilterBuilders.boolFilter().must(new FilterBuilder[]{filterTime, filterSpaceKey, filterSource});
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addField("_id").setPostFilter((FilterBuilder)filter);
        if (this.commentIndexingMode.isExtraDocumentIndexed()) {
            srb.setTypes(new String[]{this.issueTypeName, this.commentTypeName});
        } else {
            srb.setTypes(new String[]{this.issueTypeName});
        }
    }

    @Override
    public void buildSearchForIndexedDocumentsWithRemoteId(SearchRequestBuilder srb, String spaceKey, String remoteId) {
        TermFilterBuilder filterRemoteId = FilterBuilders.termFilter((String)this.indexFieldForRemoteDocumentId, (String)remoteId);
        TermFilterBuilder filterSpaceKey = FilterBuilders.termFilter((String)this.indexFieldForSpaceKey, (String)spaceKey);
        TermFilterBuilder filterSource = FilterBuilders.termFilter((String)this.indexFieldForRiverName, (String)this.riverName);
        BoolFilterBuilder filter = FilterBuilders.boolFilter().must(new FilterBuilder[]{filterRemoteId, filterSpaceKey, filterSource});
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addField("_id").setPostFilter((FilterBuilder)filter);
        if (this.commentIndexingMode.isExtraDocumentIndexed()) {
            srb.setTypes(new String[]{this.issueTypeName, this.commentTypeName});
        } else {
            srb.setTypes(new String[]{this.issueTypeName});
        }
    }

    @Override
    public boolean deleteESDocument(BulkRequestBuilder esBulk, SearchHit documentToDelete) throws Exception {
        esBulk.add(Requests.deleteRequest((String)this.indexName).type(documentToDelete.getType()).id(documentToDelete.getId()));
        return this.issueTypeName.equals(documentToDelete.getType());
    }

    protected XContentBuilder prepareIndexedDocument(String spaceKey, Map<String, Object> documentRemote) throws Exception {
        List<Map<String, Object>> comments;
        String documentId = this.extractDocumentId(documentRemote);
        XContentBuilder out = XContentFactory.jsonBuilder().startObject();
        this.addValueToTheIndexField(out, this.indexFieldForRiverName, this.riverName);
        this.addValueToTheIndexField(out, this.indexFieldForSpaceKey, spaceKey);
        this.addValueToTheIndexField(out, this.indexFieldForRemoteDocumentId, documentId);
        for (String indexFieldName : this.fieldsConfig.keySet()) {
            Map<String, String> fieldConfig = this.fieldsConfig.get(indexFieldName);
            this.addValueToTheIndex(out, indexFieldName, fieldConfig.get(CONFIG_FIELDS_REMOTEFIELD), documentRemote, fieldConfig.get(CONFIG_FIELDS_VALUEFILTER));
        }
        if (this.commentIndexingMode == CommentIndexingMode.EMBEDDED && (comments = this.extractComments(documentRemote)) != null && !comments.isEmpty()) {
            out.startArray(this.indexFieldForComments);
            for (Map<String, Object> comment : comments) {
                out.startObject();
                this.addCommonFieldsToCommentIndexedDocument(out, documentId, comment);
                out.endObject();
            }
            out.endArray();
        }
        return out.endObject();
    }

    protected XContentBuilder prepareCommentIndexedDocument(String spaceKey, String documentId, Map<String, Object> comment) throws Exception {
        XContentBuilder out = XContentFactory.jsonBuilder().startObject();
        this.addValueToTheIndexField(out, this.indexFieldForRiverName, this.riverName);
        this.addValueToTheIndexField(out, this.indexFieldForSpaceKey, spaceKey);
        this.addValueToTheIndexField(out, this.indexFieldForRemoteDocumentId, documentId);
        this.addCommonFieldsToCommentIndexedDocument(out, documentId, comment);
        return out.endObject();
    }

    private void addCommonFieldsToCommentIndexedDocument(XContentBuilder out, String documentId, Map<String, Object> comment) throws Exception {
        for (String indexFieldName : this.commentFieldsConfig.keySet()) {
            Map<String, String> commentFieldConfig = this.commentFieldsConfig.get(indexFieldName);
            this.addValueToTheIndex(out, indexFieldName, commentFieldConfig.get(CONFIG_FIELDS_REMOTEFIELD), comment, commentFieldConfig.get(CONFIG_FIELDS_VALUEFILTER));
        }
    }

    protected List<Map<String, Object>> extractComments(Map<String, Object> document) {
        List comments = (List)XContentMapValues.extractValue((String)this.remoteDataFieldForComments, document);
        return comments;
    }

    protected void addValueToTheIndex(XContentBuilder out, String indexField, String valuePath, Map<String, Object> values, String valueFieldFilterName) throws Exception {
        Map<String, String> filter = null;
        if (!Utils.isEmpty(valueFieldFilterName)) {
            filter = this.filtersConfig.get(valueFieldFilterName);
        }
        this.addValueToTheIndex(out, indexField, valuePath, values, filter);
    }

    protected void addValueToTheIndex(XContentBuilder out, String indexField, String valuePath, Map<String, Object> values, Map<String, String> valueFieldFilter) throws Exception {
        if (values == null) {
            return;
        }
        Object v = null;
        v = valuePath.contains(".") ? XContentMapValues.extractValue((String)valuePath, values) : values.get(valuePath);
        if (v != null && valueFieldFilter != null && !valueFieldFilter.isEmpty()) {
            if (v instanceof Map) {
                Utils.remapDataInMap((Map)v, valueFieldFilter);
            } else if (v instanceof List) {
                for (Object o : (List)v) {
                    if (o instanceof Map) {
                        Utils.remapDataInMap((Map)o, valueFieldFilter);
                        continue;
                    }
                    this.logger.warn("Filter defined for field which is not filterable - remote document array field '{}' with value: {}", new Object[]{valuePath, v});
                }
            } else {
                this.logger.warn("Filter defined for field which is not filterable - remote document field '{}' with value: {}", new Object[]{valuePath, v});
            }
        }
        this.addValueToTheIndexField(out, indexField, v);
    }

    protected void addValueToTheIndexField(XContentBuilder out, String indexField, Object value) throws Exception {
        if (value != null) {
            out.field(indexField, value);
        }
    }

    private Map<String, Object> loadDefaultSettingsMapFromFile() throws SettingsException {
        Map<String, Object> json = Utils.loadJSONFromJarPackagedFile("/templates/remote_river_configuration_default.json");
        return (Map)json.get("index");
    }

    private String loadDefaultStringIfNecessary(String valueToCheck, String valueConfigKey, Map<String, Object> settingsDefault) {
        if (Utils.isEmpty(valueToCheck)) {
            return XContentMapValues.nodeStringValue((Object)settingsDefault.get(valueConfigKey), null);
        }
        return valueToCheck.trim();
    }

    private void validateConfigurationFieldsStructure(Map<String, Map<String, String>> value, String configFieldName) {
        for (String idxFieldName : value.keySet()) {
            if (Utils.isEmpty(idxFieldName)) {
                throw new SettingsException("Empty key found in '" + configFieldName + "' map.");
            }
            Map<String, String> fc = value.get(idxFieldName);
            if (Utils.isEmpty(fc.get(CONFIG_FIELDS_REMOTEFIELD))) {
                throw new SettingsException("'remote_field' is not defined in '" + configFieldName + "/" + idxFieldName + "'");
            }
            String fil = fc.get(CONFIG_FIELDS_VALUEFILTER);
            if (fil == null || this.filtersConfig.containsKey(fil)) continue;
            throw new SettingsException("Filter definition not found for filter name '" + fil + "' defined in '" + configFieldName + "/" + idxFieldName + "/value_filter'");
        }
    }

    private void validateConfigurationString(String value, String configFieldName) throws SettingsException {
        if (Utils.isEmpty(value)) {
            throw new SettingsException("String value must be provided for '" + configFieldName + "' configuration!");
        }
    }

    private void validateConfigurationObject(Object value, String configFieldName) throws SettingsException {
        if (value == null) {
            throw new SettingsException("Value must be provided for '" + configFieldName + "' configuration!");
        }
    }
}

