/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IPwdLoader;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.Utils;

public abstract class HttpRemoteSystemClientBase
implements IRemoteSystemClient {
    protected static final String CFG_PASSWORD = "pwd";
    protected static final String CFG_USERNAME = "username";
    protected static final String CFG_TIMEOUT = "timeout";
    protected ESLogger myLogger = null;
    protected CloseableHttpClient httpclient;
    protected boolean isAuthConfigured = false;
    protected IDocumentIndexStructureBuilder indexStructureBuilder;

    protected String initHttpClient(ESLogger logger, Map<String, Object> config, IPwdLoader pwdLoader, String url) {
        this.myLogger = logger;
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(20);
        connManager.setMaxTotal(20);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        Integer timeout = new Long(Utils.parseTimeValue(config, CFG_TIMEOUT, 5L, TimeUnit.SECONDS)).intValue();
        if (timeout != null) {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout.intValue()).setConnectTimeout(timeout.intValue()).build();
            clientBuilder.setDefaultRequestConfig(requestConfig);
        }
        String remoteUsername = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_USERNAME), null));
        String remotePassword = XContentMapValues.nodeStringValue((Object)config.get(CFG_PASSWORD), null);
        if (remoteUsername != null) {
            if (remotePassword == null && pwdLoader != null) {
                remotePassword = pwdLoader.loadPassword(remoteUsername);
            }
            if (remotePassword != null) {
                try {
                    URL urlParsed = new URL(url);
                    String host = urlParsed.getHost();
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(remoteUsername, remotePassword));
                    clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    this.isAuthConfigured = true;
                }
                catch (MalformedURLException e) {}
            } else {
                logger.warn("Password not found so authentication is not used!", new Object[0]);
                remoteUsername = null;
            }
        } else {
            remoteUsername = null;
        }
        this.httpclient = clientBuilder.build();
        return remoteUsername;
    }

    protected static String getUrlFromConfig(Map<String, Object> config, String cfgProperyName, boolean mandatory) throws SettingsException {
        String url = null;
        if (config != null) {
            url = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(cfgProperyName), null));
        }
        if (mandatory && url == null) {
            throw new SettingsException("remote/" + cfgProperyName + " element of configuration structure not found or empty");
        }
        if (url != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new SettingsException("Parameter remote/" + cfgProperyName + " is malformed URL " + e.getMessage());
            }
        }
        return url;
    }

    protected HttpResponseContent performHttpGetCall(String url, Map<String, String> headers) throws Exception, HttpCallException {
        return this.performHttpCall(url, headers, HttpMethodType.GET);
    }

    protected HttpResponseContent performHttpPostCall(String url, Map<String, String> headers) throws Exception, HttpCallException {
        return this.performHttpCall(url, headers, HttpMethodType.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponseContent performHttpCall(String url, Map<String, String> headers, HttpMethodType methodType) throws Exception, HttpCallException {
        this.myLogger.debug("Going to perform remote system HTTP request to the the {}", new Object[]{url});
        HttpGet method = null;
        URIBuilder builder = null;
        if (methodType != null && methodType.compareTo(HttpMethodType.POST) == 0) {
            builder = new URIBuilder(url);
            String urlWithoutParams = url.split("\\?")[0];
            HttpPost postMethod = new HttpPost(urlWithoutParams);
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(builder.getQueryParams()));
            method = postMethod;
        } else {
            builder = new URIBuilder(url);
            method = new HttpGet(builder.build());
        }
        if (headers != null) {
            for (String headerName : headers.keySet()) {
                method.addHeader(headerName, headers.get(headerName));
            }
        }
        CloseableHttpResponse response = null;
        try {
            HttpHost targetHost = new HttpHost(builder.getHost(), builder.getPort(), builder.getScheme());
            HttpClientContext localcontext = HttpClientContext.create();
            if (this.isAuthConfigured) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                localcontext.setAuthCache((AuthCache)authCache);
            }
            response = this.httpclient.execute(targetHost, (HttpRequest)method, (HttpContext)localcontext);
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] responseContent = null;
            if (response.getEntity() != null) {
                responseContent = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            if (statusCode != 200) {
                throw new HttpCallException(url, statusCode, responseContent != null ? new String(responseContent) : "");
            }
            Header h = response.getFirstHeader("Content-Type");
            HttpResponseContent httpResponseContent = new HttpResponseContent(h != null ? h.getValue() : null, responseContent);
            return httpResponseContent;
        }
        finally {
            if (response != null) {
                response.close();
            }
            method.releaseConnection();
        }
    }

    @Override
    public void setIndexStructureBuilder(IDocumentIndexStructureBuilder indexStructureBuilder) {
        this.indexStructureBuilder = indexStructureBuilder;
    }

    @Override
    public IDocumentIndexStructureBuilder getIndexStructureBuilder() {
        return this.indexStructureBuilder;
    }

    public static enum HttpMethodType {
        GET,
        POST;

    }

    public static final class HttpCallException
    extends Exception {
        int statusCode;

        public HttpCallException(String url, int statusCode, String responseContent) {
            super("Failed remote system HTTP GET request to the url '" + url + "'. HTTP error code: " + statusCode + " Response body: " + responseContent);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static final class HttpResponseContent {
        public String contentType;
        public byte[] content;

        public HttpResponseContent(String contentType, byte[] content) {
            this.contentType = contentType;
            this.content = content;
        }

        public String toString() {
            return "HttpResponseContent [contentType=" + this.contentType + ", content=" + this.content != null ? new String(this.content) : "]";
        }
    }
}

