/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.sitemap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.elasticsearch.river.remote.sitemap.AbstractSiteMap;
import org.jboss.elasticsearch.river.remote.sitemap.SiteMapURL;

public class SiteMap
extends AbstractSiteMap {
    private String baseUrl;
    private Map<String, SiteMapURL> urlList = new LinkedHashMap<String, SiteMapURL>();

    public SiteMap() {
        this.setProcessed(false);
    }

    public SiteMap(URL url) {
        this();
        this.setUrl(url);
    }

    public SiteMap(String url) {
        this();
        this.setUrl(url);
    }

    public SiteMap(URL url, Date lastModified) {
        this(url);
        this.setLastModified(lastModified);
    }

    public SiteMap(String url, String lastModified) {
        this(url);
        this.setLastModified(lastModified);
    }

    public Collection<SiteMapURL> getSiteMapUrls() {
        return this.urlList.values();
    }

    private void setUrl(URL url) {
        this.url = url;
        this.setBaseUrl(url);
    }

    private void setUrl(String url) {
        try {
            this.url = new URL(url);
            this.setBaseUrl(this.url);
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
    }

    public String toString() {
        String s = "url=\"" + this.url + "\",lastMod=";
        s = s + (this.getLastModified() == null ? "null" : SiteMap.getFullDateFormat().format(this.getLastModified()));
        s = s + ",type=" + (Object)((Object)this.getType()) + ",processed=" + this.isProcessed() + ",urlListSize=" + this.urlList.size();
        return s;
    }

    private void setBaseUrl(URL sitemapUrl) {
        this.baseUrl = sitemapUrl.toString().toLowerCase();
        this.baseUrl = this.baseUrl.replaceFirst("/[^/]*$", "/");
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void addSiteMapUrl(SiteMapURL url) {
        this.urlList.put(url.getUrl().toString(), url);
    }

    @Override
    public boolean isIndex() {
        return false;
    }
}

