/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.esclient;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.jboss.elasticsearch.river.sysinfo.Utils;
import org.jboss.elasticsearch.river.sysinfo.esclient.SourceClientESClient;

public class SourceClientESTransportClient
extends SourceClientESClient {
    private static final ESLogger logger = Loggers.getLogger(SourceClientESTransportClient.class);
    protected TransportAddress[] transportAddresses;
    protected Map<String, String> settingsConf;

    public SourceClientESTransportClient(Map<String, Object> sourceClientSettings) throws SettingsException {
        super(null);
        List adr = (List)sourceClientSettings.get("addresses");
        if (adr == null || adr.isEmpty()) {
            throw new SettingsException("es_connection/addresses element of configuration structure not found or is empty");
        }
        this.transportAddresses = new TransportAddress[adr.size()];
        int i = 0;
        for (Map a : adr) {
            if (Utils.isEmpty(a.get("host"))) {
                throw new SettingsException("es_connection/addresses/host element of configuration structure not found or is empty");
            }
            if (Utils.isEmpty(a.get("port"))) {
                throw new SettingsException("es_connection/addresses/port element of configuration structure not found or is empty");
            }
            this.transportAddresses[i++] = new InetSocketTransportAddress((String)a.get("host"), Utils.nodeIntegerValue(a.get("port")).intValue());
        }
        this.settingsConf = (Map)sourceClientSettings.get("settings");
        if (this.settingsConf == null) {
            this.settingsConf = new HashMap<String, String>();
        }
    }

    protected SourceClientESTransportClient() {
        super(null);
    }

    @Override
    public synchronized void start() {
        if (this.client != null) {
            logger.info("Client started already, ignoring start() call", new Object[0]);
            return;
        }
        TransportClient tclient = new TransportClient(ImmutableSettings.settingsBuilder().put(this.settingsConf).build());
        tclient.addTransportAddresses(this.transportAddresses);
        this.client = tclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            finally {
                this.client = null;
            }
        }
    }

    public TransportAddress[] getTransportAddresses() {
        return this.transportAddresses;
    }

    public Map<String, String> getSettingsConf() {
        return this.settingsConf;
    }
}

