/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm.period;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.ClusterAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.jboss.elasticsearch.river.sysinfo.Utils;
import org.jboss.elasticsearch.river.sysinfo.mgm.JRMgmBaseActionListener;
import org.jboss.elasticsearch.river.sysinfo.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.JRPeriodAction;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.JRPeriodRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.JRPeriodResponse;
import org.jboss.elasticsearch.river.sysinfo.mgm.period.NodeJRPeriodResponse;

public class RestJRPeriodAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestJRPeriodAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        String baseUrl = this.baseRestMgmUrl();
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "{indexerName}/period/{period}", (RestHandler)this);
    }

    public void handleRequest(RestRequest restRequest, RestChannel restChannel) {
        final String indexerNames = restRequest.param("indexerName");
        final long period = Utils.parseTimeValue(restRequest.params(), "period", 1L, TimeUnit.MINUTES);
        JRPeriodRequest actionRequest = new JRPeriodRequest(restRequest.param("riverName"), RestJRPeriodAction.splitIndexerNames(indexerNames), period);
        this.client.admin().cluster().execute((ClusterAction)JRPeriodAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new JRMgmBaseActionListener<JRPeriodRequest, JRPeriodResponse, NodeJRPeriodResponse>(actionRequest, restRequest, restChannel){

            @Override
            protected void handleRiverResponse(NodeJRPeriodResponse nodeInfo) throws Exception {
                if (nodeInfo.indexerFound) {
                    this.restChannel.sendResponse((RestResponse)new XContentRestResponse(this.restRequest, RestStatus.OK, 1.buildMessageDocument(this.restRequest, "Period changed to " + period + "[ms] for at least one of defined indexers")));
                } else {
                    this.restChannel.sendResponse((RestResponse)new XContentRestResponse(this.restRequest, RestStatus.NOT_FOUND, 1.buildMessageDocument(this.restRequest, "No any of defined indexers '" + indexerNames + "' found")));
                }
            }
        });
    }

    public static String[] splitIndexerNames(String namesParam) {
        if (Utils.isEmpty(namesParam)) {
            return Strings.EMPTY_ARRAY;
        }
        return Strings.splitStringByCommaToArray((String)namesParam);
    }
}

