/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.esclient;

import java.io.IOException;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class LocalRestChannel
implements RestChannel {
    protected long TIMEOUT = 60000L;
    protected RestResponse response;

    public void sendResponse(RestResponse response) {
        this.response = response;
    }

    public String getResponseContent() throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        while (this.response == null) {
            if (System.currentTimeMillis() - start > this.TIMEOUT) {
                throw new IOException("Request timmed out after " + this.TIMEOUT + "ms");
            }
            Thread.sleep(50L);
        }
        if (this.response.status() != RestStatus.OK) {
            String c = "";
            if (this.response.content() != null) {
                c = new String(this.response.content(), 0, this.response.contentLength(), "UTF-8");
            }
            throw new IOException("response status is " + this.response.status() + " with content " + c.trim());
        }
        return new String(this.response.content(), 0, this.response.contentLength(), "UTF-8").trim();
    }

    public String toString() {
        return "LocalRestChannel [TIMEOUT=" + this.TIMEOUT + "ms, response=" + this.response + "]";
    }
}

