/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo;

import java.io.IOException;
import java.util.Map;
import org.jboss.elasticsearch.river.sysinfo.SourceClient;
import org.jboss.elasticsearch.river.sysinfo.SysinfoType;

public abstract class SourceClientBase
implements SourceClient {
    @Override
    public String readSysinfoValue(SysinfoType infoType, Map<String, String> params) throws IOException, InterruptedException {
        if (infoType == null) {
            throw new IllegalArgumentException("infoType parameter must be defined");
        }
        switch (infoType) {
            case CLUSTER_HEALTH: {
                return this.readClusterHealthInfo(params);
            }
            case CLUSTER_STATE: {
                return this.readClusterStateInfo(params);
            }
            case CLUSTER_NODES_INFO: {
                return this.readClusterNodesInfoInfo(params);
            }
            case CLUSTER_NODES_STATS: {
                return this.readClusterNodesStatsInfo(params);
            }
            case INDICES_STATUS: {
                return this.readIndicesStatusInfo(params);
            }
            case INDICES_STATS: {
                return this.readIndicesStatsInfo(params);
            }
            case INDICES_SEGMENTS: {
                return this.readIndicesSegmentsInfo(params);
            }
        }
        throw new UnsupportedOperationException("Unsupported information type: " + (Object)((Object)infoType));
    }

    protected abstract String readClusterStateInfo(Map<String, String> var1) throws IOException, InterruptedException;

    protected abstract String readClusterHealthInfo(Map<String, String> var1) throws IOException, InterruptedException;

    protected abstract String readClusterNodesInfoInfo(Map<String, String> var1) throws IOException, InterruptedException;

    protected abstract String readClusterNodesStatsInfo(Map<String, String> var1) throws IOException, InterruptedException;

    protected abstract String readIndicesStatusInfo(Map<String, String> var1) throws IOException, InterruptedException;

    protected abstract String readIndicesStatsInfo(Map<String, String> var1) throws IOException, InterruptedException;

    protected abstract String readIndicesSegmentsInfo(Map<String, String> var1) throws IOException, InterruptedException;
}

