/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm.period;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.sysinfo.mgm.JRMgmBaseRequest;

public class JRPeriodRequest
extends JRMgmBaseRequest<JRPeriodRequest> {
    protected String[] indexerNames;
    protected long period;

    JRPeriodRequest() {
    }

    public JRPeriodRequest(String riverName, String[] indexerNames, long period) {
        super(riverName);
        this.indexerNames = indexerNames;
        this.period = period;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.indexerNames = in.readStringArray();
        }
        this.period = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.indexerNames != null);
        if (this.indexerNames != null) {
            out.writeStringArray(this.indexerNames);
        }
        out.writeLong(this.period);
    }

    public String[] getIndexerNames() {
        return this.indexerNames;
    }

    public void setIndexerNames(String[] indexerNames) {
        this.indexerNames = indexerNames;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public String toString() {
        return "JRPeriodRequest [riverName=" + this.riverName + ", indexerNames=" + Arrays.toString(this.indexerNames) + ", period=" + this.period + "]";
    }
}

