/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class ESLookupValuePreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_index_name = "index_name";
    protected static final String CFG_index_type = "index_type";
    protected static final String CFG_source_field = "source_field";
    protected static final String CFG_idx_search_field = "idx_search_field";
    protected static final String CFG_idx_result_field = "idx_result_field";
    protected static final String CFG_target_field = "target_field";
    protected static final String CFG_value_default = "value_default";
    protected static final String CFG_source_bases = "source_bases";
    protected List<String> sourceBases;
    protected String indexName;
    protected String indexType;
    protected String sourceField;
    protected String idxSearchField;
    protected String idxResultField;
    protected String targetField;
    protected String valueDefault;
    private boolean esExceptionWarned = false;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (this.client == null) {
            throw new SettingsException("ElasticSearch client is required for preprocessor " + this.name);
        }
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.indexName = XContentMapValues.nodeStringValue((Object)settings.get(CFG_index_name), null);
        this.validateConfigurationStringNotEmpty(this.indexName, CFG_index_name);
        this.indexType = XContentMapValues.nodeStringValue((Object)settings.get(CFG_index_type), null);
        this.validateConfigurationStringNotEmpty(this.indexType, CFG_index_type);
        this.sourceField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_source_field), null);
        this.validateConfigurationStringNotEmpty(this.sourceField, CFG_source_field);
        this.targetField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_target_field), null);
        this.validateConfigurationStringNotEmpty(this.targetField, CFG_target_field);
        this.idxSearchField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_idx_search_field), null);
        this.validateConfigurationStringNotEmpty(this.idxSearchField, CFG_idx_search_field);
        this.idxResultField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_idx_result_field), null);
        this.validateConfigurationStringNotEmpty(this.idxResultField, CFG_idx_result_field);
        this.valueDefault = ValueUtils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CFG_value_default), null));
        this.sourceBases = (List)settings.get(CFG_source_bases);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        if (this.sourceBases == null) {
            this.processOneSourceValue(data, null);
        } else {
            LookupContenxt context = new LookupContenxt();
            for (String base : this.sourceBases) {
                Object obj = XContentMapValues.extractValue((String)base, data);
                if (obj == null) continue;
                if (obj instanceof Map) {
                    this.processOneSourceValue((Map)obj, context);
                    continue;
                }
                if (obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o instanceof Map) {
                            this.processOneSourceValue((Map)o, context);
                            continue;
                        }
                        this.logger.warn("Source base {} contains collection with invalid value to be processed {}", new Object[]{base, obj});
                    }
                    continue;
                }
                this.logger.warn("Source base {} contains invalid value to be processed {}", new Object[]{base, obj});
            }
        }
        return data;
    }

    private void processOneSourceValue(Map<String, Object> data, LookupContenxt context) {
        Object sourceValue = XContentMapValues.extractValue((String)this.sourceField, data);
        ArrayList<Object> targetValue = null;
        if (sourceValue instanceof Collection) {
            if (context == null) {
                context = new LookupContenxt();
            }
            Collection col = (Collection)sourceValue;
            ArrayList<Object> colTarget = new ArrayList<Object>();
            for (Object o : col) {
                colTarget.add(this.lookupValue(o, data, context));
            }
            targetValue = colTarget;
        } else {
            targetValue = this.lookupValue(sourceValue, data, context);
        }
        StructureUtils.putValueIntoMapOfMaps(data, this.targetField, targetValue);
    }

    protected Object lookupValue(Object sourceValue, Map<String, Object> data, LookupContenxt context) {
        Object value;
        block8: {
            value = null;
            if (sourceValue != null) {
                if (context != null && context.lookupCache.containsKey(sourceValue)) {
                    return context.lookupCache.get(sourceValue);
                }
                try {
                    SearchRequestBuilder req = this.client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexType}).addField(this.idxResultField).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.matchQuery((String)this.idxSearchField, (Object)sourceValue)));
                    SearchResponse resp = (SearchResponse)req.execute().actionGet();
                    if (resp.getHits().getTotalHits() > 0L) {
                        if (resp.getHits().getTotalHits() > 1L) {
                            this.logger.warn("More results found for lookup over value {}", new Object[]{sourceValue});
                        }
                        SearchHit hit = resp.getHits().hits()[0];
                        value = hit.field(this.idxResultField).getValue();
                    }
                    this.esExceptionWarned = false;
                }
                catch (ElasticSearchException e) {
                    if (this.esExceptionWarned) break block8;
                    this.esExceptionWarned = true;
                    this.logger.warn("ElasticSearch lookup failed due '{}:{}' so default value is used for field instead", new Object[]{((Object)((Object)e)).getClass().getName(), e.getMessage()});
                }
            }
        }
        if (value == null && this.valueDefault != null) {
            value = ValueUtils.processStringValuePatternReplacement(this.valueDefault, data, sourceValue);
        }
        if (context != null && sourceValue != null) {
            context.lookupCache.put(sourceValue, value);
        }
        return value;
    }

    private class LookupContenxt {
        Map<Object, Object> lookupCache = new HashMap<Object, Object>();

        private LookupContenxt() {
        }
    }
}

