/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class SimpleValueMapMapperPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected static final String CFG_VALUE_DEFAULT = "value_default";
    protected static final String CFG_VALUE_MAPPING = "value_mapping";
    protected String fieldSource;
    protected String fieldTarget;
    protected String defaultValue = null;
    protected Map<String, String> valueMap = null;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
        this.defaultValue = ValueUtils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CFG_VALUE_DEFAULT), null));
        this.valueMap = (Map)settings.get(CFG_VALUE_MAPPING);
        if (this.valueMap == null || this.valueMap.isEmpty()) {
            this.logger.warn("'settings/value_mapping' is not defined for preprocessor '{}'", new Object[]{this.name});
        }
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v == null) {
            this.putDefaultValue(data, null);
        } else if (v instanceof Map || v instanceof Collection || v.getClass().isArray()) {
            this.logger.warn("value for field '" + this.fieldSource + "' is not simple value (but is List or Array or Map), so can't be processed by '" + this.name + "' preprocessor", new Object[0]);
        } else {
            String origValue = v.toString();
            String newVal = null;
            if (this.valueMap != null && !ValueUtils.isEmpty(origValue)) {
                newVal = this.valueMap.get(origValue);
            }
            if (newVal != null) {
                this.putTargetValue(data, newVal);
            } else {
                this.putDefaultValue(data, origValue);
            }
        }
        return data;
    }

    private void putDefaultValue(Map<String, Object> data, String originalValue) {
        if (this.defaultValue != null) {
            this.putTargetValue(data, ValueUtils.processStringValuePatternReplacement(this.defaultValue, data, originalValue));
        }
    }

    protected void putTargetValue(Map<String, Object> data, String value) {
        StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, value);
    }
}

