/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;

public class TrimStringValuePreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected static final String CFG_MAX_SIZE = "max_size";
    protected String fieldSource;
    protected String fieldTarget;
    protected int maxSize;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
        this.maxSize = this.readMandatoryIntegerConfigValue(settings, CFG_MAX_SIZE);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v != null) {
            if (!(v instanceof String)) {
                this.logger.warn("value for field '" + this.fieldSource + "' is not String, so can't be processed by '" + this.name + "' preprocessor", new Object[0]);
            } else {
                String origValue = v.toString().trim();
                if (origValue.length() > this.maxSize) {
                    origValue = origValue.substring(0, this.maxSize);
                }
                this.putTargetValue(data, origValue);
            }
        }
        return data;
    }

    protected void putTargetValue(Map<String, Object> data, String value) {
        StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, value);
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

