/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class ValuesCollectingPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_SOURCE_FIELDS = "source_fields";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected String fieldTarget;
    protected List<String> fieldsSource;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fieldsSource = (List)settings.get(CFG_SOURCE_FIELDS);
        this.validateConfigurationObjectNotEmpty(this.fieldsSource, CFG_SOURCE_FIELDS);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        HashSet<Object> vals = new HashSet<Object>();
        for (String sourceField : this.fieldsSource) {
            Object v;
            if (ValueUtils.isEmpty(sourceField) || (v = XContentMapValues.extractValue((String)sourceField, data)) == null) continue;
            if (v instanceof Collection) {
                vals.addAll((Collection)v);
                continue;
            }
            vals.add(v);
        }
        if (vals != null && !vals.isEmpty()) {
            StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, new ArrayList(vals));
        } else {
            StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, null);
        }
        return data;
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }

    public List<String> getFieldsSource() {
        return this.fieldsSource;
    }
}

