/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class ValueUtils {
    public static final String PATTERN_KEY_ORIGINAL_VALUE = "__original";

    public static String trimToNull(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        if ((src = src.trim()).length() == 0) {
            return null;
        }
        return src;
    }

    public static boolean isEmpty(String src) {
        return src == null || src.length() == 0 || src.trim().length() == 0;
    }

    public static List<String> parseCsvString(String toParse) {
        if (toParse == null || toParse.length() == 0) {
            return null;
        }
        String[] t = toParse.split(",");
        if (t.length == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : t) {
            if (s == null || (s = s.trim()).length() <= 0) continue;
            ret.add(s);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public static String createCsvString(Collection<String> in) {
        if (in == null) {
            return null;
        }
        if (in.isEmpty()) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String s : in) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String processStringValuePatternReplacement(String patternValue, Map<String, Object> data, Object originalValue) {
        if (patternValue == null || patternValue.length() == 0) {
            return patternValue;
        }
        StringBuilder finalContent = new StringBuilder();
        boolean inBraces = false;
        StringBuilder bracesContent = null;
        for (int idx = 0; idx < patternValue.length(); ++idx) {
            char ch = patternValue.charAt(idx);
            if (!inBraces && ch == '{') {
                inBraces = true;
                bracesContent = new StringBuilder();
                continue;
            }
            if (inBraces && ch == '}') {
                inBraces = false;
                String key = bracesContent.toString();
                if (key.length() <= 0) continue;
                Object v = null;
                if (PATTERN_KEY_ORIGINAL_VALUE.equals(key)) {
                    v = originalValue;
                } else if (data != null) {
                    v = key.contains(".") ? XContentMapValues.extractValue((String)key, data) : data.get(key);
                }
                if (v == null) continue;
                finalContent.append(v.toString());
                continue;
            }
            if (inBraces) {
                bracesContent.append(ch);
                continue;
            }
            finalContent.append(ch);
        }
        if (inBraces) {
            finalContent.append("{").append((CharSequence)bracesContent);
        }
        return finalContent.toString();
    }
}

