/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class StructureUtils {
    public static Integer getIntegerValue(Map<String, Object> values, String key) throws NumberFormatException {
        if (ValueUtils.isEmpty(key)) {
            throw new IllegalArgumentException("key must be defined");
        }
        if (values == null) {
            return null;
        }
        Object node = values.get(key);
        if (node == null) {
            return null;
        }
        if (node instanceof Integer) {
            return (Integer)node;
        }
        if (node instanceof Number) {
            return new Integer(((Number)node).intValue());
        }
        return Integer.parseInt(node.toString());
    }

    public static String getStringValue(Map<String, Object> values, String key) {
        if (ValueUtils.isEmpty(key)) {
            throw new IllegalArgumentException("key must be defined");
        }
        if (values == null) {
            return null;
        }
        Object node = values.get(key);
        if (node == null) {
            return null;
        }
        return node.toString();
    }

    public static <T> void filterDataInMap(Map<T, Object> map, Set<T> keysToLeave) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (keysToLeave == null || keysToLeave.isEmpty()) {
            return;
        }
        HashSet<T> keysToRemove = new HashSet<T>(map.keySet());
        keysToRemove.removeAll(keysToLeave);
        if (!keysToRemove.isEmpty()) {
            for (Object rk : keysToRemove) {
                map.remove(rk);
            }
        }
    }

    public static <T> void remapDataInMap(Map<T, Object> mapToChange, Map<T, T> remapInstructions) {
        if (mapToChange == null || mapToChange.isEmpty()) {
            return;
        }
        if (remapInstructions == null || remapInstructions.isEmpty()) {
            return;
        }
        HashMap<T, Object> newMap = new HashMap<T, Object>();
        for (T keyOrig : mapToChange.keySet()) {
            if (!remapInstructions.containsKey(keyOrig)) continue;
            T keyNew = remapInstructions.get(keyOrig);
            newMap.put(keyNew, mapToChange.get(keyOrig));
        }
        mapToChange.clear();
        mapToChange.putAll(newMap);
    }

    public static void putValueIntoMapOfMaps(Map<String, Object> map, String field, Object value) throws IllegalArgumentException {
        if (map == null) {
            return;
        }
        if (ValueUtils.isEmpty(field)) {
            throw new IllegalArgumentException("field argument must be defined");
        }
        if (field.contains(".")) {
            String[] tokens = field.split("\\.");
            int tokensCount = tokens.length;
            LinkedHashMap<String, Object> levelData = map;
            for (String tok : tokens) {
                if (tokensCount == 1) {
                    levelData.put(tok, value);
                } else {
                    Object o = levelData.get(tok);
                    if (o == null) {
                        LinkedHashMap<String, Object> lv = new LinkedHashMap<String, Object>();
                        levelData.put(tok, lv);
                        levelData = lv;
                    } else if (o instanceof Map) {
                        levelData = (LinkedHashMap<String, Object>)o;
                    } else {
                        throw new IllegalArgumentException("Cant put value for field '" + field + "' because some element in the path is not Map");
                    }
                }
                --tokensCount;
            }
        } else {
            map.put(field, value);
        }
    }
}

